/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.speech;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import lotr.common.config.LOTRConfig;
import lotr.common.util.LOTRUtil;
import net.minecraft.entity.LivingEntity;

public class ImmersiveSpeech {
    private static final Map<Integer, TimedSpeech> speeches = new HashMap<Integer, TimedSpeech>();

    public static void update() {
        HashSet removes = new HashSet();
        speeches.forEach((id, speech) -> {
            ((TimedSpeech)speech).time--;
            if (((TimedSpeech)speech).time <= 0) {
                removes.add(id);
            }
        });
        removes.forEach(speeches::remove);
    }

    private static int getDisplayTime() {
        return LOTRUtil.secondsToTicks((Integer)LOTRConfig.CLIENT.immersiveSpeechDuration.get());
    }

    public static void receiveSpeech(LivingEntity entity, String speech) {
        speeches.put(entity.func_145782_y(), new TimedSpeech(speech, ImmersiveSpeech.getDisplayTime()));
    }

    public static void removeSpeech(LivingEntity entity) {
        ImmersiveSpeech.removeSpeech(entity.func_145782_y());
    }

    public static void removeSpeech(int entityId) {
        speeches.remove(entityId);
    }

    public static TimedSpeech getSpeechFor(LivingEntity entity) {
        return speeches.get(entity.func_145782_y());
    }

    public static boolean hasSpeech(LivingEntity entity) {
        return speeches.containsKey(entity.func_145782_y());
    }

    public static void forEach(BiConsumer<Integer, TimedSpeech> action) {
        speeches.forEach(action);
    }

    public static void clearAll() {
        speeches.clear();
    }

    public static class TimedSpeech {
        private final String speech;
        private int time;
        private final int maxTime;

        private TimedSpeech(String s, int i) {
            this.speech = s;
            this.time = i;
            this.maxTime = i;
        }

        public String getSpeech() {
            return this.speech;
        }

        public float getAge() {
            return (float)this.time / (float)this.maxTime;
        }
    }
}

