/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.speech;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lotr.client.speech.SpeechbankLoader;
import lotr.client.text.ParentTextResourceLoader;
import lotr.client.text.TranslatableTextReloadListener;
import lotr.common.speech.LOTRSpeechbankEngine;
import lotr.common.speech.NPCSpeechbankContext;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.structure.Speechbank;
import net.minecraft.client.Minecraft;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class SpeechbankResourceManager
extends TranslatableTextReloadListener<Speechbank<NPCSpeechbankContext>, ParentSpeechbankLoader<NPCSpeechbankContext>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final SpeechbankLoader<NPCSpeechbankContext> loader = new SpeechbankLoader<NPCSpeechbankContext>(LOTRSpeechbankEngine.INSTANCE);
    private static final List<String> FALLBACK_MESSAGES = ImmutableList.of((Object)"I don't have anything to say to you yet.", (Object)"Come back later for some fine conversation!", (Object)"They haven't given me speech banks yet.", (Object)"They haven't given me speech banks yet. But I do have these fine new speaking animations.", (Object)"Conditional speechbank engine - now available in a mod near you!", (Object)"$ERROR_UNKNOWN_TYPE$: SPEECHBANK NOT FOUND! No, no, just joking. But they really haven't given me any yet!", (Object)"Nopa is Based.", (Object)"I speak when I am spoken to. But I don't have much to say yet.", (Object)"What? If people were always clicking on you, you'd have trouble coming up with things to say too.", (Object)"SPEECH ERROR: java.lang.NullPointerException at NPCEn... no, that won't work on you, you're too good for that.", (Object)"Curuquesta: better than all the resta.");

    public SpeechbankResourceManager(Minecraft mc) {
        super(mc, ".json");
    }

    public Speechbank<NPCSpeechbankContext> getSpeechbank(ResourceLocation speechPath) {
        return (Speechbank)this.getOrLoadTextResource(speechPath);
    }

    @Override
    protected ResourceLocation convertToFullResourcePath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.func_110624_b(), String.format("speech/%s", basePath.func_110623_a()));
    }

    @Override
    protected Speechbank<NPCSpeechbankContext> loadResource(ResourceLocation langPath, BufferedReader reader, ParentSpeechbankLoader<NPCSpeechbankContext> parentLoader) {
        JsonObject jsonObj = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
        return this.loader.load(langPath, jsonObj, parentLoader);
    }

    @Override
    protected ParentSpeechbankLoader<NPCSpeechbankContext> createNewParentLoader(ResourceLocation topLevelPath, String lang) {
        return new ParentSpeechbankLoader<NPCSpeechbankContext>(topLevelPath, lang, this::convertToFullResourcePath, (parentPath, parentLang, parentSpeechbankLoader) -> (Speechbank)this.getOrLoadTextResource(parentPath, parentLang, false, parentSpeechbankLoader));
    }

    @Override
    protected Speechbank loadErroredFallbackResource(ResourceLocation langPath, String errorMsg) {
        return Speechbank.getFallbackSpeechbank(langPath.toString(), FALLBACK_MESSAGES);
    }

    public static class ParentSpeechbankLoader<C extends SpeechbankContextProvider>
    extends ParentTextResourceLoader<Speechbank<C>> {
        private final Function<ResourceLocation, ResourceLocation> fullPathConverter;
        private final ParentSpeechbankGetter<C> parentSpeechbankGetter;

        public ParentSpeechbankLoader(ResourceLocation topLevelSpeechbank, String langCode, Function<ResourceLocation, ResourceLocation> fullPathConverter, ParentSpeechbankGetter<C> parentSpeechbankGetter) {
            super(topLevelSpeechbank, langCode);
            this.fullPathConverter = fullPathConverter;
            this.parentSpeechbankGetter = parentSpeechbankGetter;
        }

        @Override
        public Optional<Speechbank<C>> getOrLoadParentResource(ResourceLocation parent) {
            this.checkInheritanceRecord(this.fullPathConverter.apply(parent));
            return Optional.ofNullable(this.parentSpeechbankGetter.getSpeechbank(parent, this.langCode, this));
        }

        @Override
        protected IllegalArgumentException createCircularReferenceException(ResourceLocation topLevelPath, ResourceLocation parentPath) {
            return new IllegalArgumentException(String.format("Circular reference in speechbank %s parent tree! Speechbank %s already included", topLevelPath, parentPath));
        }

        @FunctionalInterface
        public static interface ParentSpeechbankGetter<C extends SpeechbankContextProvider> {
            public Speechbank<C> getSpeechbank(ResourceLocation var1, String var2, ParentSpeechbankLoader<C> var3);
        }
    }
}

