/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import lotr.common.block.LOTRBlockStates;
import lotr.common.block.LOTRTorchBlock;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CandleBlock
extends LOTRTorchBlock {
    public static final IntegerProperty NUM_CANDLES = LOTRBlockStates.CANDLES_1_4;
    private static final VoxelShape ONE_CANDLE_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape MULTI_CANDLE_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public CandleBlock(int lightBase, int lightStep) {
        super(state -> {
            int candles = (Integer)state.func_177229_b((Property)NUM_CANDLES);
            return lightBase + (candles - 1) * lightStep;
        }, SoundType.field_185848_a);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)NUM_CANDLES, (Comparable)Integer.valueOf(1)));
        this.setParticles(() -> ParticleTypes.field_197631_x);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NUM_CANDLES});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int candles = (Integer)state.func_177229_b((Property)NUM_CANDLES);
        if (candles > 1) {
            return MULTI_CANDLE_SHAPE;
        }
        return ONE_CANDLE_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        int candles = (Integer)state.func_177229_b((Property)NUM_CANDLES);
        if (candles > 1) {
            return LOTRUtil.hasSolidSide((IBlockReader)world, pos.func_177977_b(), Direction.UP);
        }
        return super.func_196260_a(state, world, pos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        BlockState oneMoreCandle;
        int candles;
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (candles = ((Integer)state.func_177229_b((Property)NUM_CANDLES)).intValue()) < 4 && (oneMoreCandle = (BlockState)state.func_206870_a((Property)NUM_CANDLES, (Comparable)Integer.valueOf(candles + 1))).func_196955_c((IWorldReader)useContext.func_195991_k(), useContext.func_195995_a())) {
            return true;
        }
        return super.func_196253_a(state, useContext);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_177230_c() == this) {
            int candles = (Integer)state.func_177229_b((Property)NUM_CANDLES);
            return (BlockState)state.func_206870_a((Property)NUM_CANDLES, (Comparable)Integer.valueOf(Math.min(4, candles + 1)));
        }
        return super.func_196258_a(context);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        int candles = (Integer)state.func_177229_b((Property)NUM_CANDLES);
        if (candles == 1) {
            this.animateTorch(world, pos, rand, 0.5, 0.7, 0.5);
        } else if (candles == 2) {
            this.animateTorch(world, pos, rand, 0.3125, 0.575, 0.3125);
            this.animateTorch(world, pos, rand, 0.6875, 0.7, 0.6875);
        } else if (candles == 3) {
            this.animateTorch(world, pos, rand, 0.4375, 0.575, 0.25);
            this.animateTorch(world, pos, rand, 0.25, 0.575, 0.625);
            this.animateTorch(world, pos, rand, 0.75, 0.7, 0.6875);
        } else if (candles == 4) {
            this.animateTorch(world, pos, rand, 0.3125, 0.6375, 0.3125);
            this.animateTorch(world, pos, rand, 0.75, 0.575, 0.25);
            this.animateTorch(world, pos, rand, 0.25, 0.575, 0.75);
            this.animateTorch(world, pos, rand, 0.75, 0.7, 0.6875);
        }
    }
}

