/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import lotr.common.block.LOTRDoubleGrassBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DoubleTorchBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    private static final VoxelShape LOWER_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape UPPER_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);

    public DoubleTorchBlock(int light) {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_235838_a_(DoubleTorchBlock.getDoubleTorchLightLevel(light)).func_200947_a(SoundType.field_185848_a));
    }

    public DoubleTorchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    private static ToIntFunction<BlockState> getDoubleTorchLightLevel(int level) {
        return state -> {
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
            if (half == DoubleBlockHalf.UPPER) {
                return level;
            }
            return 0;
        };
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (half == DoubleBlockHalf.UPPER) {
            return UPPER_SHAPE;
        }
        return LOWER_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (half == DoubleBlockHalf.UPPER) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.6;
            double d2 = (double)pos.func_177952_p() + 0.5;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (facing.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != half) {
            if (half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.func_196955_c((IWorldReader)world, currentPos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            if (state.func_196955_c((IWorldReader)world, currentPos)) {
                return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        if (pos.func_177956_o() >= context.func_195991_k().func_230315_m_().func_241513_m_() - 1 || !context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return null;
        }
        return super.func_196258_a(context);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            boolean isPresent;
            boolean bl = isPresent = state.func_177230_c() == this;
            if (!isPresent) {
                return true;
            }
            BlockState belowState = world.func_180495_p(pos.func_177977_b());
            return belowState.func_177230_c() == this && belowState.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        }
        return DoubleTorchBlock.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public void placeTorchAt(IWorld world, BlockPos pos, int flags) {
        world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        world.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!world.field_72995_K && player.func_184812_l_()) {
            LOTRDoubleGrassBlock.accessRemoveBottomHalf(world, pos, state, player);
        }
        super.func_176208_a(world, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF});
    }
}

