/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import lotr.common.init.LOTRBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LOTRTorchBlock
extends TorchBlock {
    protected List<Supplier<? extends IParticleData>> torchParticles;

    public LOTRTorchBlock(AbstractBlock.Properties properties) {
        super(properties, (IParticleData)ParticleTypes.field_197631_x);
        this.setParticles(() -> ParticleTypes.field_197601_L, () -> ParticleTypes.field_197631_x);
    }

    public LOTRTorchBlock(int light) {
        this(light, SoundType.field_185848_a);
    }

    public LOTRTorchBlock(int light, SoundType sound) {
        this(LOTRBlocks.constantLight(light), sound);
    }

    public LOTRTorchBlock(ToIntFunction<BlockState> lightLevel, SoundType sound) {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_235838_a_(lightLevel).func_200947_a(sound));
    }

    public LOTRTorchBlock setParticles(Supplier<? extends IParticleData> ... pars) {
        this.torchParticles = Arrays.asList(pars);
        return this;
    }

    public List<Supplier<? extends IParticleData>> copyTorchParticles() {
        return new ArrayList<Supplier<? extends IParticleData>>(this.torchParticles);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        this.animateTorch(world, pos, rand, 0.5, 0.7, 0.5);
    }

    protected void animateTorch(World world, BlockPos pos, Random rand, double x, double y, double z) {
        double d0 = (double)pos.func_177958_n() + x;
        double d1 = (double)pos.func_177956_o() + y;
        double d2 = (double)pos.func_177952_p() + z;
        for (Supplier<? extends IParticleData> particle : this.torchParticles) {
            world.func_195594_a(particle.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

