/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import lotr.common.block.LOTRBlockStates;
import lotr.common.entity.item.FallingTreasureBlockEntity;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRParticles;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;

public class TreasurePileBlock
extends FallingBlock
implements IWaterLoggable {
    public static final IntegerProperty PILE_LEVEL = LOTRBlockStates.TREASURE_PILE_LEVEL;
    public static final int PILE_MAX_LEVEL = 8;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty SUCH_WEALTH = LOTRBlockStates.SUCH_WEALTH;
    private static final Map<Integer, VoxelShape> PILE_SHAPES = new HashMap<Integer, VoxelShape>();
    private static final VoxelShape COLLISION_FULL = VoxelShapes.func_197868_b();
    private static final VoxelShape COLLISION_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape COLLISION_MIN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public TreasurePileBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PILE_LEVEL, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SUCH_WEALTH, (Comparable)Boolean.valueOf(false)));
    }

    public TreasurePileBlock(MaterialColor color) {
        this(AbstractBlock.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)color).func_200943_b(0.4f).harvestTool(ToolType.SHOVEL).func_200942_a().func_200947_a(LOTRBlocks.SOUND_TREASURE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PILE_LEVEL, WATERLOGGED, SUCH_WEALTH});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int level = (Integer)state.func_177229_b((Property)PILE_LEVEL);
        VoxelShape shape = PILE_SHAPES.get(level);
        if (shape == null) {
            shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)((double)level / 8.0 * 16.0), (double)16.0);
            PILE_SHAPES.put(level, shape);
        }
        return shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int level = (Integer)state.func_177229_b((Property)PILE_LEVEL);
        if (level == 8) {
            return COLLISION_FULL;
        }
        if (level >= 4) {
            return COLLISION_HALF;
        }
        return COLLISION_MIN;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        if (type == PathType.LAND && (Integer)state.func_177229_b((Property)PILE_LEVEL) < 4) {
            return true;
        }
        return super.func_196266_a(state, world, pos, type);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        int level = (Integer)state.func_177229_b((Property)PILE_LEVEL);
        if (context.func_195996_i().func_77973_b() == this.func_199767_j() && level < 8 && context.func_196012_c()) {
            return context.func_196000_l() == Direction.UP;
        }
        return super.func_196253_a(state, context);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        boolean water = world.func_204610_c(pos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        BlockState placeState = this.func_176223_P();
        BlockState currentState = world.func_180495_p(pos);
        if (currentState.func_177230_c() == this) {
            int level = (Integer)currentState.func_177229_b((Property)PILE_LEVEL);
            placeState = (BlockState)currentState.func_206870_a((Property)PILE_LEVEL, (Comparable)Integer.valueOf(Math.min(level + 1, 8)));
        }
        return (BlockState)((BlockState)placeState.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).func_206870_a((Property)SUCH_WEALTH, (Comparable)Boolean.valueOf(this.isSuchWealth((IWorldReader)world, pos)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos belowPos = pos.func_177977_b();
        BlockState belowState = world.func_180495_p(belowPos);
        return Block.func_208061_a((VoxelShape)belowState.func_196951_e((IBlockReader)world, belowPos), (Direction)Direction.UP);
    }

    private boolean isSuchWealth(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.DIRT);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing == Direction.DOWN) {
            state = (BlockState)state.func_206870_a((Property)SUCH_WEALTH, (Comparable)Boolean.valueOf(this.isSuchWealth((IWorldReader)world, currentPos)));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        BlockPos belowPos = pos.func_177977_b();
        BlockState belowState = world.func_180495_p(belowPos);
        if (world.func_175623_d(pos.func_177977_b()) || (FallingBlock.func_185759_i((BlockState)belowState) || !this.func_196260_a(state, (IWorldReader)world, pos)) && pos.func_177956_o() >= 0) {
            FallingTreasureBlockEntity fallingBlock = new FallingTreasureBlockEntity((World)world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
            world.func_217376_c((Entity)fallingBlock);
        }
    }

    public void func_176502_a_(World world, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        this.onEndFallingTreasure(world, pos, fallingState, hitState);
    }

    public void onEndFallingTreasure(World world, BlockPos pos, BlockState fallingState, BlockState hitState) {
        BlockState updatedState = (BlockState)fallingState.func_206870_a((Property)SUCH_WEALTH, (Comparable)Boolean.valueOf(this.isSuchWealth((IWorldReader)world, pos)));
        world.func_180501_a(pos, updatedState, 3);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        double speedSq = entity.func_213322_ci().func_189985_c();
        if (speedSq > 0.01 && !entity.func_226271_bk_()) {
            this.spawnWalkingParticles(world, pos, entity, 1 + world.field_73012_v.nextInt(2));
        }
    }

    private void spawnWalkingParticles(World world, BlockPos pos, Entity entity, int num) {
        BlockState state = world.func_180495_p(pos);
        for (int l = 0; l < num; ++l) {
            double x = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double y = (double)pos.func_177956_o() + state.func_196954_c((IBlockReader)world, pos).func_197758_c(Direction.Axis.Y);
            double z = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            double velX = MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.15f, (float)0.15f);
            double velY = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.1f, (float)0.4f);
            double velZ = MathHelper.func_151240_a((Random)world.field_73012_v, (float)-0.15f, (float)0.15f);
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), x, y, z, velX, velY, velZ);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        this.spawnWalkingParticles(world, pos, entity, 8);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (world.field_73012_v.nextInt(3) == 0) {
            TreasurePileBlock.doTreasureParticles(state, world, pos, rand);
        }
    }

    public static void doTreasureParticles(BlockState state, World world, BlockPos pos, Random rand) {
        Direction face = Direction.func_239631_a_((Random)rand);
        BlockPos facePos = pos.func_177972_a(face);
        if (!world.func_180495_p(facePos).func_224755_d((IBlockReader)world, facePos, face.func_176734_d())) {
            double x = 0.5;
            double z = 0.5;
            double y = 0.0;
            double outside = 0.02;
            double width = 0.5 + outside;
            double minY = state.func_196954_c((IBlockReader)world, pos).func_197762_b(Direction.Axis.Y) - outside;
            double maxY = state.func_196954_c((IBlockReader)world, pos).func_197758_c(Direction.Axis.Y) + outside;
            if (face.func_176740_k() == Direction.Axis.X) {
                x += (double)face.func_82601_c() * width;
                y = MathHelper.func_82716_a((Random)rand, (double)minY, (double)maxY);
                z += MathHelper.func_82716_a((Random)rand, (double)(-width), (double)width);
            } else if (face.func_176740_k() == Direction.Axis.Y) {
                x += MathHelper.func_82716_a((Random)rand, (double)(-width), (double)width);
                if (face == Direction.DOWN) {
                    y = minY;
                } else if (face == Direction.UP) {
                    y = maxY;
                }
                z += MathHelper.func_82716_a((Random)rand, (double)(-width), (double)width);
            } else if (face.func_176740_k() == Direction.Axis.Z) {
                x += MathHelper.func_82716_a((Random)rand, (double)(-width), (double)width);
                y = MathHelper.func_82716_a((Random)rand, (double)minY, (double)maxY);
                z += (double)face.func_82599_e() * width;
            }
            world.func_195594_a((IParticleData)LOTRParticles.GLITTER.get(), x += (double)pos.func_177958_n(), y += (double)pos.func_177956_o(), z += (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

