/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block.trees;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import lotr.common.block.trees.PartyTreeLogic;
import lotr.common.world.biome.LOTRBiomeFeatures;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;

public class VanillaSaplingPartyTrees {
    private static final Map<ResourceLocation, PartyTreeLogic> partyTrees = new HashMap<ResourceLocation, PartyTreeLogic>();

    private static void putPartyTree(Block block, PartyTreeLogic.PartyTreeProvider tree) {
        if (block.getRegistryName().func_110624_b().equals("lotr")) {
            throw new IllegalArgumentException("Saplings from the mod itself should be handled directly with PartyTreeLogic in their own Tree instances! This workaround is for vanilla saplings.");
        }
        partyTrees.put(block.getRegistryName(), new PartyTreeLogic(tree));
    }

    public static boolean attemptGrowPartyTree(BlockState sapling, ServerWorld sWorld, ChunkGenerator chunkGen, BlockPos pos, Random rand) {
        PartyTreeLogic partyTree;
        Optional<ResourceLocation> matchingBlockName = partyTrees.keySet().stream().filter(arg_0 -> ((ResourceLocation)sapling.func_177230_c().getRegistryName()).equals(arg_0)).findFirst();
        return matchingBlockName.isPresent() && (partyTree = partyTrees.get(matchingBlockName.get())).attemptGrowPartyTree(sWorld, chunkGen, pos, sapling, rand);
    }

    static {
        VanillaSaplingPartyTrees.putPartyTree(Blocks.field_196674_t, rand -> LOTRBiomeFeatures.oakParty());
        VanillaSaplingPartyTrees.putPartyTree(Blocks.field_196676_v, rand -> LOTRBiomeFeatures.birchParty());
        VanillaSaplingPartyTrees.putPartyTree(Blocks.field_196680_y, rand -> LOTRBiomeFeatures.darkOakParty());
    }
}

