/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.data.FastTravelDataModule;
import lotr.common.util.LOTRUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FastTravelClockCommand
extends LOTRBaseCommand {
    private static final int MAX_CLOCK_SECONDS = 1000000;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftclock").requires(context -> context.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(context -> FastTravelClockCommand.setFTClock((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"))))).then(Commands.func_197057_a((String)"max").executes(context -> FastTravelClockCommand.setFTClock((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), 1000000)))));
    }

    private static int setFTClock(CommandSource source, Collection<ServerPlayerEntity> players, int seconds) {
        ITextComponent hmsTime = LOTRUtil.getHMSTime_Seconds(seconds);
        int ticks = seconds * 20;
        int clocked = 0;
        for (ServerPlayerEntity player : players) {
            FastTravelDataModule ftData = FastTravelClockCommand.getPlayerData(player).getFastTravelData();
            ftData.setTimeSinceFTWithUpdate(ticks);
            ++clocked;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.ftclock.set.single", new Object[]{players.iterator().next().func_145748_c_(), seconds, hmsTime}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.ftclock.set.multiple", new Object[]{players.size(), seconds, hmsTime}), true);
        }
        return clocked;
    }
}

