/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import lotr.common.command.arguments.LOTRTimeArgument;
import lotr.common.time.LOTRTime;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LOTRTimeCommand {
    private static final int SUNRISE = 1680;
    private static final int NOON = 12000;
    private static final int SUNSET = 25920;
    private static final int MIDNIGHT = 36000;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lotr_time").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197057_a((String)"day").executes(context -> LOTRTimeCommand.setTime((CommandSource)context.getSource(), 1680)))).then(Commands.func_197057_a((String)"noon").executes(context -> LOTRTimeCommand.setTime((CommandSource)context.getSource(), 12000)))).then(Commands.func_197057_a((String)"night").executes(context -> LOTRTimeCommand.setTime((CommandSource)context.getSource(), 25920)))).then(Commands.func_197057_a((String)"midnight").executes(context -> LOTRTimeCommand.setTime((CommandSource)context.getSource(), 36000)))).then(Commands.func_197056_a((String)"time", (ArgumentType)LOTRTimeArgument.create()).executes(context -> LOTRTimeCommand.setTime((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"time", (ArgumentType)LOTRTimeArgument.create()).executes(context -> LOTRTimeCommand.addTime((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"query").then(Commands.func_197057_a((String)"daytime").executes(context -> LOTRTimeCommand.sendQueryResults((CommandSource)context.getSource(), LOTRTimeCommand.getModuloDayTime(((CommandSource)context.getSource()).func_197023_e()))))).then(Commands.func_197057_a((String)"gametime").executes(context -> LOTRTimeCommand.sendQueryResults((CommandSource)context.getSource(), (int)(((CommandSource)context.getSource()).func_197023_e().func_82737_E() % Integer.MAX_VALUE))))).then(Commands.func_197057_a((String)"day").executes(context -> LOTRTimeCommand.sendQueryResults((CommandSource)context.getSource(), (int)(LOTRTimeCommand.getTotalDayTime(((CommandSource)context.getSource()).func_197023_e()) / 48000L % Integer.MAX_VALUE))))));
    }

    private static long getTotalDayTime(ServerWorld world) {
        return LOTRTime.getWorldTime((IWorldReader)world);
    }

    private static int getModuloDayTime(ServerWorld world) {
        return (int)(LOTRTimeCommand.getTotalDayTime(world) % 48000L);
    }

    private static int sendQueryResults(CommandSource source, int time) {
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.time.query", new Object[]{time}), false);
        return time;
    }

    public static int setTime(CommandSource source, int time) {
        LOTRTime.setWorldTime((World)source.func_197023_e(), time);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.time.set", new Object[]{time}), true);
        return LOTRTimeCommand.getModuloDayTime(source.func_197023_e());
    }

    public static int addTime(CommandSource source, int amount) {
        LOTRTime.addWorldTime((World)source.func_197023_e(), amount);
        int i = LOTRTimeCommand.getModuloDayTime(source.func_197023_e());
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.time.set", new Object[]{i}), true);
        return i;
    }
}

