/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.command.arguments.PlayerMessageTypeArgument;
import lotr.common.data.PlayerMessageType;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PlayerMessageCommand
extends LOTRBaseCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lotr_message").requires(context -> context.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197057_a((String)"preset").then(Commands.func_197056_a((String)"type", (ArgumentType)PlayerMessageTypeArgument.messageType()).executes(context -> PlayerMessageCommand.sendPresetMessage((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), PlayerMessageTypeArgument.getMessageType(context, "type")))))).then(Commands.func_197057_a((String)"custom").then(Commands.func_197056_a((String)"text", (ArgumentType)StringArgumentType.string()).executes(context -> PlayerMessageCommand.sendCustomMessage((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"text")))))));
    }

    private static int sendPresetMessage(CommandSource source, Collection<ServerPlayerEntity> players, PlayerMessageType messageType) {
        int sent = 0;
        for (ServerPlayerEntity player : players) {
            messageType.displayTo(player, true);
            ++sent;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.message.preset.single", new Object[]{players.iterator().next().func_145748_c_(), messageType.getSaveName()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.message.preset.multiple", new Object[]{players.size(), messageType.getSaveName()}), true);
        }
        return sent;
    }

    private static int sendCustomMessage(CommandSource source, Collection<ServerPlayerEntity> players, String customText) {
        int sent = 0;
        for (ServerPlayerEntity player : players) {
            PlayerMessageType.displayCustomMessageTo(player, true, customText);
            ++sent;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.message.custom.single", new Object[]{players.iterator().next().func_145748_c_(), customText}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.message.custom.multiple", new Object[]{players.size(), customText}), true);
        }
        return sent;
    }
}

