/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lotr.common.command.LOTRArgumentTypes;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionPointer;
import lotr.common.fac.FactionPointers;
import lotr.common.fac.FactionSettings;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class FactionArgument
implements ArgumentType<FactionPointer> {
    private static final Collection<String> EXAMPLES = Arrays.asList(FactionPointers.ROHAN.getNameString(), FactionPointers.ISENGARD.getNameString());
    public static final DynamicCommandExceptionType FACTION_BAD_ID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("argument.lotr.faction.id.invalid", new Object[]{arg}));

    public static FactionArgument faction() {
        return new FactionArgument();
    }

    public FactionPointer parse(StringReader reader) throws CommandSyntaxException {
        FactionSettings currentFactions = LOTRArgumentTypes.getCurrentSidedFactionSettings();
        if (currentFactions == null) {
            return FactionPointers.UNALIGNED;
        }
        int cursor = reader.getCursor();
        ResourceLocation name = ResourceLocation.func_195826_a((StringReader)reader);
        FactionPointer pointer = FactionPointer.of(name);
        if (pointer.resolveFaction(currentFactions).filter(Faction::isPlayableAlignmentFaction).isPresent()) {
            return pointer;
        }
        reader.setCursor(cursor);
        throw FACTION_BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)name.toString());
    }

    public static <S> FactionPointer getFactionPointer(CommandContext<S> context, String name) {
        return (FactionPointer)context.getArgument(name, FactionPointer.class);
    }

    public static <S> Faction getFaction(CommandContext<S> context, String name) {
        return FactionArgument.getFactionPointer(context, name).resolveFaction(LOTRArgumentTypes.getCurrentSidedFactionSettings()).orElse(null);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a(LOTRArgumentTypes.getCurrentSidedFactionSettings().getPlayableFactionNames(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

