/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.compatibility;

import java.lang.reflect.Field;
import lotr.common.LOTRLog;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.fml.ModList;

public class SnowRealMagicCompatibility {
    private static Feature<NoFeatureConfig> FREEZE_TOP_LAYER;

    public static Feature<NoFeatureConfig> getFreezeTopLayerFeature() {
        if (FREEZE_TOP_LAYER == null) {
            if (ModList.get().isLoaded("snowrealmagic")) {
                try {
                    Class<?> cls = Class.forName("snownee.snow.world.gen.feature.WorldModule");
                    Field f = cls.getDeclaredField("FEATURE");
                    FREEZE_TOP_LAYER = (Feature)f.get(null);
                    LOTRLog.info("Established compatibility with SnowRealMagic mod");
                }
                catch (ClassNotFoundException | NoSuchFieldException e) {
                    LOTRLog.error("Warning - SnowRealMagic compatibility is out of date - they must have changed their class or field names. You will likely experience a crash.");
                    e.printStackTrace();
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOTRLog.error("Error establishing compatibility with SnowRealMagic.");
                    e.printStackTrace();
                }
            } else {
                FREEZE_TOP_LAYER = Feature.field_202325_Y;
            }
        }
        return FREEZE_TOP_LAYER;
    }
}

