/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.coremod;

import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.datafix.LOTRDataFixes;
import lotr.common.dim.AddModDimensionToOldWorlds;
import lotr.common.event.MiddleEarthRespawning;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRDimensions;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;

public class InjectMethods {

    public static class Respawning {
        public static BlockPos getCheckedBedRespawnPosition(BlockPos bedRespawnPosition, ServerPlayerEntity player) {
            return MiddleEarthRespawning.getCheckedBedRespawnPosition(bedRespawnPosition, player);
        }

        public static ServerWorld getDefaultRespawnWorld(ServerWorld defaultRespawnWorld, ServerPlayerEntity player) {
            return MiddleEarthRespawning.getDefaultRespawnWorld(defaultRespawnWorld, player);
        }

        public static void relocatePlayerIfNeeded(Optional<Vector3d> optBedRespawnPosition, ServerPlayerEntity newPlayer, ServerPlayerEntity deadPlayer) {
            MiddleEarthRespawning.relocatePlayerIfNeeded(optBedRespawnPosition, newPlayer, deadPlayer);
        }
    }

    public static class Biomes {
        public static boolean doesSnowGenerate(boolean defaultDoesSnowGenerate, Biome biome, IWorldReader world, BlockPos pos) {
            return LOTRBiomes.getWrapperFor(biome, (IWorld)LOTRBiomes.getServerBiomeContextWorld()).doesSnowGenerate(defaultDoesSnowGenerate, world, pos);
        }

        public static boolean doesWaterFreeze(boolean defaultDoesWaterFreeze, Biome biome, IWorldReader world, BlockPos pos, boolean mustBeAtEdge) {
            return LOTRBiomes.getWrapperFor(biome, (IWorld)LOTRBiomes.getServerBiomeContextWorld()).doesWaterFreeze(defaultDoesWaterFreeze, world, pos, mustBeAtEdge);
        }

        public static float getTemperatureRaw(float defaultTemperatureAtPos, Biome biome, BlockPos pos) {
            ServerWorld world = LOTRBiomes.getServerBiomeContextWorld();
            if (world == null) {
                if (LOTRMod.PROXY.isClient()) {
                    world = LOTRMod.PROXY.getClientWorld();
                } else {
                    LOTRLog.warn("Unexpected call to biome#getTemperatureRaw (biome %s) which could not determine the current world context. This should never happen within the LOTR mod but may happen if other mods are installed. Defaulting to vanilla behaviour as fallback.", biome);
                    return defaultTemperatureAtPos;
                }
            }
            return LOTRBiomes.getWrapperFor(biome, (IWorld)world).getTemperatureRaw(defaultTemperatureAtPos, pos);
        }
    }

    public static class Dimensions {
        public static void registerDimensionTypes(MutableRegistry<DimensionType> dimTypeReg) {
            LOTRDimensions.registerDimensionTypes(dimTypeReg);
        }

        public static void registerWorldDimensions(SimpleRegistry<Dimension> dimReg, Registry<DimensionType> dimTypeReg, Registry<Biome> biomeReg, Registry<DimensionSettings> dimSettingsReg, long seed) {
            LOTRDimensions.registerWorldDimensions(dimReg, dimTypeReg, biomeReg, dimSettingsReg, seed);
        }

        public static void addModDimensionToOldWorlds(DynamicOps<INBT> nbtOps, SaveFormat.LevelSave levelSave, ServerWorldInfo serverInfo) {
            AddModDimensionToOldWorlds.operateOnWorldSave(nbtOps, levelSave, serverInfo);
        }

        public static DataResult<RegistryKey<World>> checkDecodableModWorldKey(DataResult<RegistryKey<World>> defaultResult, Dynamic<?> dynamic) {
            return AddModDimensionToOldWorlds.checkDecodableModWorldKey(defaultResult, dynamic);
        }

        public static List<Map.Entry<RegistryKey<Dimension>, Dimension>> removeAddedDimensionsFromExperimentalConsideration(List<Map.Entry<RegistryKey<Dimension>, Dimension>> inputList) {
            return inputList.stream().filter(entry -> !LOTRDimensions.isAddedDimension((RegistryKey<Dimension>)((RegistryKey)entry.getKey()))).collect(Collectors.toList());
        }
    }

    public static class DataFixes {
        public static void addModFixers(DataFixerBuilder builder) {
            LOTRDataFixes.addFixers(builder);
        }
    }
}

