/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.BitSet;
import java.util.stream.Stream;
import lotr.common.config.ClientsideCurrentServerConfigSettings;
import lotr.common.config.LOTRConfig;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerDataModule;
import lotr.common.util.LOTRUtil;
import lotr.common.world.map.MapExploration;
import lotr.common.world.map.MapExplorationTile;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.world.server.ServerWorld;

public class FogDataModule
extends PlayerDataModule {
    private final MapExploration mapExploration = new MapExploration();
    private static final int EXPLORATION_UPDATE_INTERVAL = LOTRUtil.secondsToTicks(5);

    protected FogDataModule(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void save(CompoundNBT playerNBT) {
        playerNBT.func_218657_a("MapExploration", (INBT)this.mapExploration.save(new CompoundNBT()));
    }

    @Override
    public void load(CompoundNBT playerNBT) {
        this.mapExploration.load(playerNBT.func_74775_l("MapExploration"), this.getPlayerUUID());
    }

    @Override
    protected void sendLoginData(PacketBuffer buf) {
        this.mapExploration.write(buf);
    }

    @Override
    protected void receiveLoginData(PacketBuffer buf) {
        this.mapExploration.read(buf);
    }

    public static boolean isFogOfWarEnabledClientside() {
        int forcedFromServer = ClientsideCurrentServerConfigSettings.INSTANCE.forceFogOfWar;
        if (forcedFromServer == 1) {
            return true;
        }
        if (forcedFromServer == 2) {
            return false;
        }
        return (Boolean)LOTRConfig.CLIENT.fogOfWar.get();
    }

    public boolean isFogged(int mapX, int mapZ) {
        if (!FogDataModule.isFogOfWarEnabledClientside()) {
            return false;
        }
        return !this.mapExploration.isExplored(mapX, mapZ);
    }

    @Override
    protected void onUpdate(ServerPlayerEntity player, ServerWorld world, int tick) {
        MapSettings currentMap = MapSettingsManager.serverInstance().getCurrentLoadedMap();
        if (currentMap != null) {
            if (this.mapExploration.initialiseIfEmptyOrChanged(player, currentMap)) {
                this.markDirty();
            }
            if (tick % EXPLORATION_UPDATE_INTERVAL == 0 && this.mapExploration.onUpdate(player, currentMap)) {
                this.markDirty();
            }
        }
    }

    public void receiveFullGridFromServer(PacketBuffer buf) {
        this.mapExploration.read(buf);
    }

    public void receiveSingleTileUpdateFromServer(int mapX, int mapZ, BitSet tileBits) {
        this.mapExploration.receiveSingleTileUpdateFromServer(mapX, mapZ, tileBits);
    }

    public Stream<MapExplorationTile> streamTilesForRendering(double mapXMin, double mapXMax, double mapZMin, double mapZMax, IProfiler profiler) {
        return this.mapExploration.streamTilesForRendering(mapXMin, mapXMax, mapZMin, mapZMax, profiler);
    }
}

