/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.HashSet;
import java.util.Set;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerDataModule;
import lotr.common.data.PlayerMessageType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class MessageDataModule
extends PlayerDataModule {
    private Set<PlayerMessageType> sentMessages = new HashSet<PlayerMessageType>();

    protected MessageDataModule(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void save(CompoundNBT playerNBT) {
        ListNBT sentMessageTags = new ListNBT();
        for (PlayerMessageType message : this.sentMessages) {
            sentMessageTags.add((Object)StringNBT.func_229705_a_((String)message.getSaveName()));
        }
        playerNBT.func_218657_a("SentMessageTypes", (INBT)sentMessageTags);
    }

    @Override
    public void load(CompoundNBT playerNBT) {
        this.sentMessages.clear();
        ListNBT sentMessageTags = playerNBT.func_150295_c("SentMessageTypes", 8);
        for (int i = 0; i < sentMessageTags.size(); ++i) {
            String messageName = sentMessageTags.func_150307_f(i);
            PlayerMessageType messageType = PlayerMessageType.forSaveName(messageName);
            if (messageType != null) {
                this.sentMessages.add(messageType);
                continue;
            }
            this.playerData.logPlayerError("Loaded nonexistent player message type %s", messageName);
        }
    }

    public void sendMessageIfNotReceived(PlayerMessageType message) {
        this.executeIfPlayerExistsServerside(player -> {
            if (!this.sentMessages.contains((Object)message)) {
                this.sentMessages.add(message);
                this.markDirty();
                message.displayTo((ServerPlayerEntity)player, false);
            }
        });
    }
}

