/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.datagen;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.item.VesselDrinkItem;
import lotr.common.loot.functions.SetNPCDrinkPotency;
import lotr.common.loot.functions.SetPouchColorFromEntityFaction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NPCLootTableGenerator
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final Map<ResourceLocation, LootTable.Builder> lootTables = new HashMap<ResourceLocation, LootTable.Builder>();
    private final LootParameterSet parameterSet = LootParameterSets.field_216263_d;

    public NPCLootTableGenerator(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    private void constructLootTables() {
        ResourceLocation orcBones = this.makeCommonPart("orc_bones", this.tableWithSinglePoolOfItemWithCount((IItemProvider)LOTRItems.ORC_BONE.get(), 1.0f));
        ResourceLocation elfBones = this.makeCommonPart("elf_bones", this.tableWithSinglePoolOfItemWithCount((IItemProvider)LOTRItems.ELF_BONE.get(), 1.0f));
        ResourceLocation manBones = this.makeCommonPart("man_bones", this.tableWithSinglePoolOfItemWithCount((IItemProvider)Items.field_151103_aS, 1.0f));
        ResourceLocation dwarfBones = this.makeCommonPart("dwarf_bones", this.tableWithSinglePoolOfItemWithCount((IItemProvider)LOTRItems.DWARF_BONE.get(), 1.0f));
        ResourceLocation hobbitBones = this.makeCommonPart("hobbit_bones", this.tableWithSinglePoolOfItemWithCount((IItemProvider)LOTRItems.HOBBIT_BONE.get(), 1.0f));
        ResourceLocation wargBones = this.makeCommonPart("warg_bones", LootTable.func_216119_b().func_216040_a(this.poolWithItemEntryWithCount((IItemProvider)LOTRItems.WARG_BONE.get(), 1.0f, 3.0f)));
        ResourceLocation wargFurs = this.makeCommonPart("warg_furs", LootTable.func_216119_b().func_216040_a(this.poolWithItemEntryWithCount((IItemProvider)LOTRItems.FUR.get(), 1.0f, 3.0f)));
        ResourceLocation arrows = this.makeCommonPart("arrows", this.tableWithSinglePoolOfItemWithCount((IItemProvider)Items.field_151032_g, 2.0f));
        ResourceLocation elfLembas = this.makeCommonPart("elf_lembas", LootTable.func_216119_b().func_216040_a(this.poolWithItemEntry((IItemProvider)LOTRItems.LEMBAS.get())));
        ResourceLocation dwarfRareDrops = this.makeCommonPart("dwarf_rare_drops", LootTable.func_216119_b().func_216040_a(this.pool().func_216045_a((LootEntry.Builder)this.itemLootEntry((IItemProvider)Items.field_151042_j)).func_216045_a((LootEntry.Builder)this.itemLootEntry((IItemProvider)LOTRItems.DWARVEN_STEEL_INGOT.get())).func_216045_a((LootEntry.Builder)this.itemLootEntryWithCountAndLootingBonus((IItemProvider)Items.field_151074_bl, 1.0f, 3.0f, 0.0f, 1.0f)).func_216045_a((LootEntry.Builder)this.itemLootEntryWithCountAndLootingBonus((IItemProvider)LOTRItems.SILVER_NUGGET.get(), 1.0f, 3.0f, 0.0f, 1.0f))));
        ResourceLocation pouch = this.makeCommonPart("pouch", LootTable.func_216119_b().func_216040_a(this.pool().func_216045_a((LootEntry.Builder)this.itemLootEntry((IItemProvider)LOTRItems.SMALL_POUCH.get()).func_216086_a(6)).func_216045_a((LootEntry.Builder)this.itemLootEntry((IItemProvider)LOTRItems.MEDIUM_POUCH.get()).func_216086_a(3)).func_216045_a((LootEntry.Builder)this.itemLootEntry((IItemProvider)LOTRItems.LARGE_POUCH.get()).func_216086_a(1)).func_212841_b_(SetPouchColorFromEntityFaction.setPouchColorFromEntityFactionBuilder(0.5f)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChance.func_216004_a((float)0.016666f))));
        ResourceLocation orcBase = this.makeCommonPart("orc", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcBones)).func_216040_a(this.poolWithSingleEntryOfOtherTable(pouch)).func_216040_a(this.poolWithItemEntryWithCount((IItemProvider)Items.field_151078_bh, 2.0f)).func_216040_a(this.poolWithItemEntryWithCount((IItemProvider)LOTRItems.MAGGOTY_BREAD.get(), 1.0f, 2.0f).func_212840_b_(RandomChance.func_216004_a((float)0.1f))).func_216040_a(this.poolWithItemEntryWithDrinkPotency((IItemProvider)LOTRItems.ORC_DRAUGHT.get()).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.025f, (float)0.008f))));
        ResourceLocation orcWithOrcSteel = this.makeCommonPart("orc_with_orc_steel", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcBase)).func_216040_a(this.poolWithItemEntryWithCount((IItemProvider)LOTRItems.ORC_STEEL_INGOT.get(), 1.0f, 2.0f).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.025f, (float)0.008f))));
        ResourceLocation orcWithUrukSteel = this.makeCommonPart("orc_with_uruk_steel", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcBase)).func_216040_a(this.poolWithItemEntryWithCount((IItemProvider)LOTRItems.URUK_STEEL_INGOT.get(), 1.0f, 2.0f).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.025f, (float)0.008f))));
        ResourceLocation elfBase = this.makeCommonPart("elf", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(elfBones)).func_216040_a(this.poolWithSingleEntryOfOtherTable(pouch)).func_216040_a(this.poolWithSingleEntryOfOtherTable(arrows)));
        ResourceLocation elfWithMiruvor = this.makeCommonPart("elf_with_miruvor", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(elfBase)).func_216040_a(this.poolWithItemEntryWithDrinkPotency((IItemProvider)LOTRItems.MIRUVOR.get()).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.016f))));
        ResourceLocation manBase = this.makeCommonPart("man", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBones)).func_216040_a(this.poolWithSingleEntryOfOtherTable(pouch)));
        ResourceLocation dwarfBase = this.makeCommonPart("dwarf", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(dwarfBones)).func_216040_a(this.poolWithSingleEntryOfOtherTable(pouch)).func_216040_a(this.poolWithSingleEntryOfOtherTable(dwarfRareDrops).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.016f))).func_216040_a(this.poolWithItemEntry((IItemProvider)LOTRItems.BOOK_OF_TRUE_SILVER.get()).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.025f, (float)0.005f))));
        ResourceLocation hobbitBase = this.makeCommonPart("hobbit", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(hobbitBones)).func_216040_a(this.poolWithSingleEntryOfOtherTable(pouch)));
        ResourceLocation wargBase = this.makeCommonPart("warg", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(wargBones)).func_216040_a(this.poolWithSingleEntryOfOtherTable(wargFurs)));
        ResourceLocation hobbit = this.makeFactionBase("hobbit", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(hobbitBase)));
        ResourceLocation breeMan = this.makeFactionBase("bree_man", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation breeHobbit = this.makeFactionBase("bree_hobbit", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(hobbitBase)));
        ResourceLocation blueMountains = this.makeFactionBase("blue_mountains", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(dwarfBase)));
        ResourceLocation lindon = this.makeFactionBase("lindon", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(elfWithMiruvor)));
        ResourceLocation rivendell = this.makeFactionBase("rivendell", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(elfWithMiruvor)));
        ResourceLocation gundabad = this.makeFactionBase("gundabad", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcWithOrcSteel)));
        ResourceLocation woodElf = this.makeFactionBase("wood_elf", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(elfBase)));
        ResourceLocation dale = this.makeFactionBase("dale", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation durinsFolk = this.makeFactionBase("durins_folk", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(dwarfBase)));
        ResourceLocation galadhrim = this.makeFactionBase("galadhrim", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(elfWithMiruvor)).func_216040_a(this.poolWithSingleEntryOfOtherTable(elfLembas).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.025f, (float)0.008f))));
        ResourceLocation dunlending = this.makeFactionBase("dunlending", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation uruk = this.makeFactionBase("uruk", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcWithUrukSteel)));
        ResourceLocation isengardSnaga = this.makeFactionBase("isengard_snaga", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcWithOrcSteel)));
        ResourceLocation rohan = this.makeFactionBase("rohan", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation gondor = this.makeFactionBase("gondor", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation mordor = this.makeFactionBase("mordor", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(orcWithOrcSteel)));
        ResourceLocation harnedhrim = this.makeFactionBase("harnedhrim", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation coastSouthron = this.makeFactionBase("coast_southron", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        ResourceLocation umbar = this.makeFactionBase("umbar", LootTable.func_216119_b().func_216040_a(this.poolWithSingleEntryOfOtherTable(manBase)));
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.HOBBIT, hobbit);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.MORDOR_ORC, mordor);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GONDOR_MAN, gondor);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GALADHRIM_ELF, galadhrim);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GONDOR_SOLDIER, gondor);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DWARF, durinsFolk);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DWARF_WARRIOR, durinsFolk);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GALADHRIM_WARRIOR, galadhrim);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.URUK, uruk);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.ROHAN_MAN, rohan);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.ROHIRRIM_WARRIOR, rohan);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GUNDABAD_ORC, gundabad);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DALE_MAN, dale);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DALE_SOLDIER, dale);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DUNLENDING, dunlending);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DUNLENDING_WARRIOR, dunlending);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.LINDON_ELF, lindon);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.LINDON_WARRIOR, lindon);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.RIVENDELL_ELF, rivendell);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.RIVENDELL_WARRIOR, rivendell);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.COAST_SOUTHRON, coastSouthron);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.COAST_SOUTHRON_WARRIOR, coastSouthron);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.HARNEDHRIM, harnedhrim);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.HARNENNOR_WARRIOR, harnedhrim);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.BLUE_MOUNTAINS_DWARF, blueMountains);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.BLUE_MOUNTAINS_WARRIOR, blueMountains);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.UMBAR_MAN, umbar);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.UMBAR_SOLDIER, umbar);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GONDOR_ARCHER, gondor, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.ROHIRRIM_BOWMAN, rohan, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DALE_BOWMAN, dale, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DUNLENDING_BOWMAN, dunlending, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.COAST_SOUTHRON_ARCHER, coastSouthron, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.HARNENNOR_ARCHER, harnedhrim, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.UMBAR_ARCHER, umbar, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.MORDOR_ORC_ARCHER, mordor, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GUNDABAD_ORC_ARCHER, gundabad, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.URUK_ARCHER, uruk, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.DWARF_ARCHER, durinsFolk, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.BLUE_MOUNTAINS_ARCHER, blueMountains, arrows);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.WOOD_ELF, woodElf);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.WOOD_ELF_WARRIOR, woodElf);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.BREE_MAN, breeMan);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.BREE_HOBBIT, breeHobbit);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.BREE_GUARD, breeMan);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.GUNDABAD_WARG, wargBase);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.ISENGARD_WARG, wargBase);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.MORDOR_WARG, wargBase);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.ISENGARD_SNAGA, isengardSnaga);
        this.makeEntityTableFromPools((Supplier<? extends EntityType<? extends Entity>>)LOTREntities.ISENGARD_SNAGA_ARCHER, isengardSnaga, arrows);
    }

    private void makeEntityTable(Supplier<? extends EntityType<? extends Entity>> entityType, LootTable.Builder builder) {
        this.lootTables.put(new ResourceLocation("lotr", "entities/" + entityType.get().getRegistryName().func_110623_a()), builder);
    }

    private void makeEntityTableFromPools(Supplier<? extends EntityType<? extends Entity>> entityType, ResourceLocation ... basePools) {
        LootTable.Builder tableBuilder = LootTable.func_216119_b();
        Stream.of(basePools).forEach(pool -> tableBuilder.func_216040_a(this.poolWithSingleEntryOfOtherTable((ResourceLocation)pool)));
        this.makeEntityTable(entityType, tableBuilder);
    }

    private ResourceLocation makeCommonPart(String name, LootTable.Builder builder) {
        ResourceLocation path = new ResourceLocation("lotr", "entities/common/parts/" + name);
        this.lootTables.put(path, builder);
        return path;
    }

    private ResourceLocation makeFactionBase(String name, LootTable.Builder builder) {
        ResourceLocation path = new ResourceLocation("lotr", "entities/common/faction_bases/" + name);
        this.lootTables.put(path, builder);
        return path;
    }

    private LootTable.Builder tableWithSinglePoolOfItemWithCount(IItemProvider item, float maxCount) {
        return LootTable.func_216119_b().func_216040_a(this.poolWithItemEntryWithCount(item, maxCount));
    }

    private LootPool.Builder pool() {
        return this.pool(1);
    }

    private LootPool.Builder pool(int rolls) {
        return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)rolls));
    }

    private LootPool.Builder poolWithItemEntryWithCount(IItemProvider item, float maxCount) {
        return this.poolWithItemEntryWithCount(item, 0.0f, maxCount);
    }

    private LootPool.Builder poolWithItemEntryWithCount(IItemProvider item, float minCount, float maxCount) {
        return this.poolWithItemEntry(item, itemLootEntry -> itemLootEntry.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minCount, (float)maxCount))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))));
    }

    private LootPool.Builder poolWithItemEntryWithDrinkPotency(IItemProvider item) {
        Item asItem = item.func_199767_j();
        if (!(asItem instanceof VesselDrinkItem) || !((VesselDrinkItem)asItem).hasPotencies) {
            throw new IllegalArgumentException(asItem.getRegistryName() + " is not a drink item with potencies");
        }
        return this.poolWithItemEntry(item, itemLootEntry -> itemLootEntry.func_212841_b_(SetNPCDrinkPotency.setNPCDrinkPotencyBuilder()));
    }

    private LootPool.Builder poolWithItemEntry(IItemProvider item) {
        return this.poolWithItemEntry(item, itemLootEntry -> {});
    }

    private LootPool.Builder poolWithItemEntry(IItemProvider item, Consumer<StandaloneLootEntry.Builder<?>> lootFunctionAdder) {
        StandaloneLootEntry.Builder itemLootEntry = this.itemLootEntry(item);
        lootFunctionAdder.accept(itemLootEntry);
        return this.pool().func_216045_a((LootEntry.Builder)itemLootEntry);
    }

    private LootPool.Builder poolWithSingleEntryOfOtherTable(ResourceLocation otherTable) {
        return this.pool().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)otherTable));
    }

    private StandaloneLootEntry.Builder itemLootEntry(IItemProvider item) {
        return ItemLootEntry.func_216168_a((IItemProvider)item);
    }

    private StandaloneLootEntry.Builder itemLootEntryWithCount(IItemProvider item, float minCount, float maxCount) {
        return this.itemLootEntry(item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minCount, (float)maxCount)));
    }

    private StandaloneLootEntry.Builder itemLootEntryWithCountAndLootingBonus(IItemProvider item, float minCount, float maxCount) {
        return this.itemLootEntryWithCountAndLootingBonus(item, minCount, maxCount, 0.0f, 1.0f);
    }

    private StandaloneLootEntry.Builder itemLootEntryWithCountAndLootingBonus(IItemProvider item, float minCount, float maxCount, float minBonus, float maxBonus) {
        return this.itemLootEntryWithCount(item, minCount, maxCount).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)minBonus, (float)maxBonus)));
    }

    public void func_200398_a(DirectoryCache cache) {
        this.constructLootTables();
        Path rootPath = this.dataGenerator.func_200391_b();
        HashMap tables = Maps.newHashMap();
        this.lootTables.forEach((name, tableBuilder) -> {
            if (tables.put(name, tableBuilder.func_216039_a(this.parameterSet).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + name);
            }
        });
        ValidationTracker validationTracker = new ValidationTracker(LootParameterSets.field_216266_g, name -> null, tables::get);
        this.validate(tables, validationTracker);
        Multimap problems = validationTracker.func_227527_a_();
        if (!problems.isEmpty()) {
            problems.forEach((tableName, problem) -> LOGGER.warn("Found validation problem in " + tableName + ": " + problem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        tables.forEach((name, lootTable) -> {
            Path path = NPCLootTableGenerator.getPath(rootPath, name);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't generate loot table {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationTracker) {
        for (ResourceLocation name2 : Sets.intersection((Set)LootTables.func_215796_a(), map.keySet())) {
            validationTracker.func_227530_a_("Shouldn't be overwriting built-in table: " + name2);
        }
        map.keySet().stream().filter(name -> !name.func_110624_b().equals("lotr")).forEach(name -> validationTracker.func_227530_a_("Table " + name + " is not in the mod's own namespace"));
        map.forEach((name, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationTracker, (ResourceLocation)name, (LootTable)lootTable));
    }

    private static Path getPath(Path path, ResourceLocation name) {
        return path.resolve("data/" + name.func_110624_b() + "/loot_tables/" + name.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "LOTRNPCLootTables";
    }
}

