/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lotr.common.entity.ai.goal.CaracalRaidChestGoal;
import lotr.common.init.LOTREntities;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CaracalEntity
extends CatEntity {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_151076_bf, Items.field_179558_bo});
    public static final Predicate<ItemStack> WANTS_TO_EAT = BREEDING_ITEMS.or(stack -> stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c());
    private static final DataParameter<Boolean> IS_RAIDING_CHEST = EntityDataManager.func_187226_a(CaracalEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARE_EARS_ALERT = EntityDataManager.func_187226_a(CaracalEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_FLOPPING = EntityDataManager.func_187226_a(CaracalEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private TemptGoal temptGoal;
    private CaracalAvoidPlayerGoal<PlayerEntity> avoidPlayerGoal;
    private int eatTick;
    private static final int EATING_ITEM_STATUS_UPDATE = 45;
    private float yawWhenSat;
    private boolean wasSitting = false;
    private int earsAlertTimer = 0;
    private int floppingTimer = 0;

    public CaracalEntity(EntityType<? extends CaracalEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
        this.field_70749_g = new CaracalLookController(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_RAIDING_CHEST, (Object)false);
        this.field_70180_af.func_187214_a(ARE_EARS_ALERT, (Object)false);
        this.field_70180_af.func_187214_a(IS_FLOPPING, (Object)false);
    }

    protected void func_184651_r() {
        this.temptGoal = new CaracalTemptGoal(this, 0.6, BREEDING_ITEMS, true);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new CaracalMorningGiftGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)this.temptGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new CatLieOnBedGoal((CatEntity)this, 1.1, 8));
        this.field_70714_bg.func_75776_a(7, (Goal)new CaracalRaidChestGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(9, (Goal)new CatSitOnBlockGoal((CatEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(11, (Goal)new OcelotAttackGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(12, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(13, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8, 1.0E-5f));
        this.field_70714_bg.func_75776_a(13, (Goal)new CaracalFindItemsGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(14, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RabbitEntity.class, 10, false, false, null));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ChickenEntity.class, 10, false, false, null));
    }

    protected void func_175544_ck() {
        if (this.avoidPlayerGoal == null) {
            this.avoidPlayerGoal = new CaracalAvoidPlayerGoal<PlayerEntity>(this, PlayerEntity.class, 16.0f, 0.8, 1.33);
        }
        this.field_70714_bg.func_85156_a(this.avoidPlayerGoal);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(5, this.avoidPlayerGoal);
        }
    }

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return CatEntity.func_234184_eY_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    public boolean isRaidingChest() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_RAIDING_CHEST);
    }

    public void setIsRaidingChest(boolean flag) {
        this.field_70180_af.func_187227_b(IS_RAIDING_CHEST, (Object)flag);
    }

    public boolean areEarsAlert() {
        return (Boolean)this.field_70180_af.func_187225_a(ARE_EARS_ALERT);
    }

    private void setAreEarsAlert(boolean flag) {
        this.field_70180_af.func_187227_b(ARE_EARS_ALERT, (Object)flag);
    }

    public boolean isFlopping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLOPPING);
    }

    private void setIsFlopping(boolean flag) {
        this.field_70180_af.func_187227_b(IS_FLOPPING, (Object)flag);
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70605_aq().func_75640_a()) {
            double speed = this.func_70605_aq().func_75638_b();
            if (speed <= 0.6) {
                this.func_213301_b(Pose.CROUCHING);
                this.func_70031_b(false);
            } else if (speed >= 1.33) {
                this.func_213301_b(Pose.STANDING);
                this.func_70031_b(true);
            } else {
                this.func_213301_b(Pose.STANDING);
                this.func_70031_b(false);
            }
        } else {
            this.func_213301_b(Pose.STANDING);
            this.func_70031_b(false);
        }
        if (this.isRaidingChest()) {
            this.func_213301_b(Pose.CROUCHING);
            this.func_70031_b(true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_233684_eK_()) {
            if (!this.wasSitting) {
                this.yawWhenSat = this.field_70177_z;
            }
            this.field_70761_aq = this.field_70177_z = this.yawWhenSat;
        }
        this.wasSitting = this.func_233684_eK_();
        if (this.temptGoal != null && this.temptGoal.func_75277_f() && !this.func_70909_n() && this.field_70173_aa % 100 == 0) {
            this.func_184185_a(SoundEvents.field_219608_aI, 1.0f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.earsAlertTimer < 0) {
                ++this.earsAlertTimer;
            } else if (this.areEarsAlert()) {
                --this.earsAlertTimer;
                if (this.earsAlertTimer <= 0) {
                    this.setAreEarsAlert(false);
                    this.earsAlertTimer = -LOTRUtil.secondsToTicks(10 + this.field_70146_Z.nextInt(15));
                }
            }
            if (this.floppingTimer < 0) {
                ++this.floppingTimer;
            } else if (!this.isFlopping()) {
                if (this.field_70146_Z.nextInt(600) == 0) {
                    this.setIsFlopping(true);
                    int maxFlopSeconds = this.isFloppa() ? 10 : 6;
                    this.floppingTimer = LOTRUtil.secondsToTicks(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)maxFlopSeconds));
                }
            } else {
                --this.floppingTimer;
                if (this.floppingTimer <= 0) {
                    this.setIsFlopping(false);
                    this.floppingTimer = -LOTRUtil.secondsToTicks(30 + this.field_70146_Z.nextInt(200));
                    if (this.isFloppa()) {
                        this.floppingTimer /= 2;
                    }
                }
            }
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.func_70909_n() && this.func_233685_eM_() && player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_187645_R, 0.6f + 0.4f * (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean isFloppa() {
        return this.func_70909_n() && this.func_145818_k_() && CaracalEntity.nameContainsAny(this.func_200201_e().getString(), "floppa", "gregory", "gosha");
    }

    private static boolean nameContainsAny(String name, String ... matches) {
        return Stream.of(matches).map(String::toLowerCase).anyMatch(name.toLowerCase()::contains);
    }

    public CaracalEntity createChild(ServerWorld world, AgeableEntity mate) {
        CaracalEntity caracal = (CaracalEntity)((EntityType)LOTREntities.CARACAL.get()).func_200721_a((World)world);
        CatEntity superChild = super.func_241840_a(world, mate);
        caracal.func_184754_b(superChild.func_184753_b());
        caracal.func_70903_f(superChild.func_70909_n());
        caracal.func_213417_a(superChild.func_213414_ei());
        return caracal;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b * 0.85f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (flag && this.func_233684_eK_()) {
            this.func_233686_v_(false);
        }
        return flag;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.65f;
    }

    public int func_70627_aG() {
        return 200;
    }

    public SoundEvent func_213353_d(ItemStack stack) {
        return SoundEvents.field_219607_aG;
    }

    public boolean hasItemInMouth() {
        return !this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
    }

    public ItemStack getItemInMouth() {
        return this.func_184582_a(EquipmentSlotType.MAINHAND);
    }

    public void setItemInMouth(ItemStack stack) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            ++this.eatTick;
            if (this.eatTick >= 560) {
                ItemStack heldItem = this.getItemInMouth();
                if (this.canEatItem(heldItem)) {
                    if (this.canEatItemNow(heldItem)) {
                        if (this.eatTick > 600) {
                            ItemStack eatResult = heldItem.func_77950_b(this.field_70170_p, (LivingEntity)this);
                            this.func_195063_d(Effects.field_76438_s);
                            if (!eatResult.func_190926_b()) {
                                if (this.canEatItem(eatResult)) {
                                    this.setItemInMouth(eatResult);
                                } else {
                                    this.func_199701_a_(eatResult);
                                    this.setItemInMouth(ItemStack.field_190927_a);
                                }
                            }
                            this.eatTick = 0;
                        } else if (this.eatTick > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                            this.func_184185_a(this.func_213353_d(heldItem), 1.0f, 1.0f);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                        }
                    }
                } else {
                    this.func_199701_a_(heldItem);
                    this.setItemInMouth(ItemStack.field_190927_a);
                }
            }
        }
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        int healAmount = stack.func_222117_E() ? stack.func_77973_b().func_219967_s().func_221466_a() : 0;
        ItemStack result = super.func_213357_a(world, stack);
        if (!world.field_72995_K && healAmount > 0) {
            this.func_70691_i(healAmount);
        }
        return result;
    }

    public boolean canEatItem(ItemStack stack) {
        return WANTS_TO_EAT.test(stack);
    }

    private boolean canEatItemNow(ItemStack stack) {
        return this.canEatItem(stack) && this.func_70638_az() == null && this.field_70122_E && !this.func_70608_bn();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack heldItem = this.getItemInMouth();
            if (!heldItem.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d crumbMotion = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70177_z));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, heldItem), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, crumbMotion.field_72450_a, crumbMotion.field_72448_b + 0.05, crumbMotion.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_175448_a(ItemStack stack) {
        ItemStack currentHeldItem = this.getItemInMouth();
        return this.canEatItem(stack) && (currentHeldItem.func_190926_b() || this.eatTick > 0 && !this.canEatItem(currentHeldItem));
    }

    public boolean func_213365_e(ItemStack stack) {
        EquipmentSlotType slotType = MobEntity.func_184640_d((ItemStack)stack);
        if (!this.func_184582_a(slotType).func_190926_b()) {
            return false;
        }
        return slotType == EquipmentSlotType.MAINHAND && super.func_213365_e(stack);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        if (this.func_175448_a(stack)) {
            int count = stack.func_190916_E();
            if (count > 1) {
                this.dropItemBack(stack.func_77979_a(count - 1));
            }
            this.spitOutCurrentItemInMouth();
            this.func_233630_a_(itemEntity);
            this.setItemInMouth(stack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, stack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTick = 0;
        }
    }

    private void dropItemBack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    private void spitOutCurrentItemInMouth() {
        ItemStack stack = this.getItemInMouth();
        if (!stack.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity drop = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stack);
            drop.func_174867_a(40);
            drop.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)drop);
        }
    }

    protected void func_213345_d(DamageSource source) {
        ItemStack heldItem = this.getItemInMouth();
        if (!heldItem.func_190926_b()) {
            this.func_199701_a_(heldItem);
            this.setItemInMouth(ItemStack.field_190927_a);
        }
        super.func_213345_d(source);
    }

    static class CaracalFindItemsGoal
    extends Goal {
        private static final Predicate<ItemEntity> ITEM_SELECTOR = itemEntity -> !itemEntity.func_174874_s() && itemEntity.func_70089_S() && WANTS_TO_EAT.test(itemEntity.func_92059_d());
        private final CaracalEntity caracal;
        private final double speed;

        public CaracalFindItemsGoal(CaracalEntity caracal, double speed) {
            this.caracal = caracal;
            this.speed = speed;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.caracal.func_70681_au().nextInt(10) == 0 && this.func_75253_b();
        }

        public boolean func_75253_b() {
            if (this.caracal.hasItemInMouth()) {
                return false;
            }
            if (!this.caracal.func_233685_eM_() && this.caracal.func_70638_az() == null && this.caracal.func_70643_av() == null) {
                return this.findDroppedItem() != null;
            }
            return false;
        }

        private ItemEntity findDroppedItem() {
            List items = this.caracal.field_70170_p.func_175647_a(ItemEntity.class, this.caracal.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!items.isEmpty()) {
                return (ItemEntity)items.get(0);
            }
            return null;
        }

        public void func_75249_e() {
            ItemEntity droppedItem = this.findDroppedItem();
            if (droppedItem != null) {
                this.caracal.func_70661_as().func_75497_a((Entity)droppedItem, this.speed);
            }
        }

        public void func_75246_d() {
            ItemEntity droppedItem;
            if (!this.caracal.hasItemInMouth() && (droppedItem = this.findDroppedItem()) != null) {
                this.caracal.func_70661_as().func_75497_a((Entity)droppedItem, this.speed);
            }
        }
    }

    static class CaracalTemptGoal
    extends TemptGoal {
        @Nullable
        private PlayerEntity temptingPlayer;
        private final CaracalEntity caracal;

        public CaracalTemptGoal(CaracalEntity caracal, double speed, Ingredient temptItems, boolean scaredByPlayerMovement) {
            super((CreatureEntity)caracal, speed, temptItems, scaredByPlayerMovement);
            this.caracal = caracal;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.temptingPlayer == null && this.caracal.func_70681_au().nextInt(600) == 0) {
                this.temptingPlayer = this.field_75289_h;
            } else if (this.caracal.func_70681_au().nextInt(500) == 0) {
                this.temptingPlayer = null;
            }
        }

        protected boolean func_220761_g() {
            return this.temptingPlayer != null && this.temptingPlayer.equals((Object)this.field_75289_h) ? false : super.func_220761_g();
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.caracal.func_70909_n();
        }
    }

    static class CaracalMorningGiftGoal
    extends Goal {
        private final CaracalEntity caracal;
        private PlayerEntity theOwner;
        private BlockPos bedPos;
        private int tickCounter;

        public CaracalMorningGiftGoal(CaracalEntity caracal) {
            this.caracal = caracal;
        }

        public boolean func_75250_a() {
            if (!this.caracal.func_70909_n()) {
                return false;
            }
            if (this.caracal.func_233685_eM_()) {
                return false;
            }
            LivingEntity owner = this.caracal.func_70902_q();
            if (owner instanceof PlayerEntity) {
                this.theOwner = (PlayerEntity)owner;
                if (!this.theOwner.func_70608_bn()) {
                    return false;
                }
                if (this.caracal.func_70068_e((Entity)this.theOwner) > 100.0) {
                    return false;
                }
                BlockPos ownerPos = this.theOwner.func_233580_cy_();
                BlockState state = this.caracal.field_70170_p.func_180495_p(ownerPos);
                if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
                    this.bedPos = state.func_235903_d_((Property)BedBlock.field_185512_D).map(dir -> ownerPos.func_177972_a(dir.func_176734_d())).orElseGet(() -> new BlockPos((Vector3i)ownerPos));
                    return !this.anyOtherCaracalsGivingGifts();
                }
            }
            return false;
        }

        private boolean anyOtherCaracalsGivingGifts() {
            return this.caracal.field_70170_p.func_217357_a(CaracalEntity.class, new AxisAlignedBB(this.bedPos).func_186662_g(2.0)).stream().filter(otherCaracal -> otherCaracal != this.caracal).anyMatch(otherCaracal -> otherCaracal.func_213416_eg() || otherCaracal.func_213409_eh());
        }

        public boolean func_75253_b() {
            return this.caracal.func_70909_n() && !this.caracal.func_233685_eM_() && this.theOwner != null && this.theOwner.func_70608_bn() && this.bedPos != null && !this.anyOtherCaracalsGivingGifts();
        }

        public void func_75249_e() {
            if (this.bedPos != null) {
                this.caracal.func_233686_v_(false);
                this.caracal.func_70661_as().func_75492_a((double)this.bedPos.func_177958_n(), (double)this.bedPos.func_177956_o(), (double)this.bedPos.func_177952_p(), (double)1.1f);
            }
        }

        public void func_75251_c() {
            this.caracal.func_213419_u(false);
            float skyAngle = this.caracal.field_70170_p.func_242415_f(1.0f);
            if (this.theOwner.func_71060_bI() >= 100 && skyAngle > 0.77f && skyAngle < 0.8f && this.caracal.field_70170_p.func_201674_k().nextFloat() < 0.7f) {
                this.spawnGiftItem();
            }
            this.tickCounter = 0;
            this.caracal.func_213415_v(false);
            this.caracal.func_70661_as().func_75499_g();
        }

        private void spawnGiftItem() {
            Random rand = this.caracal.func_70681_au();
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            movingPos.func_189533_g((Vector3i)this.caracal.func_233580_cy_());
            this.caracal.func_213373_a(movingPos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)-5, (int)5), movingPos.func_177956_o() + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2), movingPos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)-5, (int)5), false);
            movingPos.func_189533_g((Vector3i)this.caracal.func_233580_cy_());
            LootTable lootTable = this.caracal.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_215797_af);
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.caracal.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.caracal.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this.caracal).func_216023_a(rand);
            float yawRadians = (float)Math.toRadians(this.caracal.field_70761_aq);
            lootTable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216264_e)).forEach(lootStack -> this.caracal.field_70170_p.func_217376_c((Entity)new ItemEntity(this.caracal.field_70170_p, (double)((float)movingPos.func_177958_n() - MathHelper.func_76126_a((float)yawRadians)), (double)movingPos.func_177956_o(), (double)((float)movingPos.func_177952_p() + MathHelper.func_76134_b((float)yawRadians)), lootStack)));
        }

        public void func_75246_d() {
            if (this.theOwner != null && this.bedPos != null) {
                this.caracal.func_233686_v_(false);
                this.caracal.func_70661_as().func_75492_a((double)this.bedPos.func_177958_n(), (double)this.bedPos.func_177956_o(), (double)this.bedPos.func_177952_p(), (double)1.1f);
                if (this.caracal.func_70068_e((Entity)this.theOwner) < 2.5) {
                    ++this.tickCounter;
                    if (this.tickCounter > 16) {
                        this.caracal.func_213419_u(true);
                        this.caracal.func_213415_v(false);
                    } else {
                        this.caracal.func_70625_a((Entity)this.theOwner, 45.0f, 45.0f);
                        this.caracal.func_213415_v(true);
                    }
                } else {
                    this.caracal.func_213419_u(false);
                }
            }
        }
    }

    static class CaracalAvoidPlayerGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final CaracalEntity caracal;

        public CaracalAvoidPlayerGoal(CaracalEntity caracal, Class<T> entityClassToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
            super((CreatureEntity)caracal, entityClassToAvoid, avoidDistance, farSpeed, nearSpeed, EntityPredicates.field_188444_d::test);
            this.caracal = caracal;
        }

        public boolean func_75250_a() {
            return !this.caracal.func_70909_n() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.caracal.func_70909_n() && super.func_75253_b();
        }
    }

    public static class CaracalLookController
    extends LookController {
        private final CaracalEntity theCaracal;

        public CaracalLookController(CaracalEntity caracal) {
            super((MobEntity)caracal);
            this.theCaracal = caracal;
        }

        public void func_75649_a() {
            if (this.field_75655_d && !this.theCaracal.areEarsAlert() && this.theCaracal.earsAlertTimer >= 0 && this.theCaracal.field_70146_Z.nextInt(60) == 0) {
                this.theCaracal.setAreEarsAlert(true);
                this.theCaracal.earsAlertTimer = LOTRUtil.secondsToTicks(1 + this.theCaracal.field_70146_Z.nextInt(2));
            }
            super.func_75649_a();
        }
    }
}

