/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.item;

import java.util.Optional;
import lotr.common.block.TreasurePileBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTREntities;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class FallingTreasureBlockEntity
extends Entity {
    private int fallTime;
    private boolean shouldDropItem = true;
    private boolean dontSetBlock;
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(FallingTreasureBlockEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<BlockState>> FALL_TILE = EntityDataManager.func_187226_a(FallingTreasureBlockEntity.class, (IDataSerializer)DataSerializers.field_187197_g);

    public FallingTreasureBlockEntity(EntityType<? extends FallingTreasureBlockEntity> type, World world) {
        super(type, world);
    }

    public FallingTreasureBlockEntity(World world, double x, double y, double z, BlockState fallingBlockState) {
        this((EntityType<? extends FallingTreasureBlockEntity>)((EntityType)LOTREntities.FALLING_TREASURE_BLOCK.get()), world);
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setOrigin(this.func_233580_cy_());
        this.setFallTile(fallingBlockState);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(FALL_TILE, Optional.empty());
    }

    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public void setFallTile(BlockState state) {
        this.field_70180_af.func_187227_b(FALL_TILE, Optional.of(state));
    }

    public BlockState getFallTile() {
        return ((Optional)this.field_70180_af.func_187225_a(FALL_TILE)).orElse(Blocks.field_150350_a.func_176223_P());
    }

    public boolean func_70075_an() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    private boolean isValidFallTile() {
        BlockState fallTile = this.getFallTile();
        return !fallTile.func_196958_f() && fallTile.func_177230_c() instanceof TreasurePileBlock;
    }

    public void func_70071_h_() {
        if (!this.isValidFallTile()) {
            this.func_70106_y();
        } else {
            BlockPos thisPos;
            BlockState fallTile = this.getFallTile();
            Block block = fallTile.func_177230_c();
            if (this.fallTime++ == 0) {
                thisPos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(thisPos).func_177230_c() == block) {
                    this.field_70170_p.func_217377_a(thisPos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                thisPos = this.func_233580_cy_();
                boolean flag1 = false;
                if (!this.field_70122_E && !flag1) {
                    if (!(this.field_70170_p.field_72995_K || (this.fallTime <= 100 || thisPos.func_177956_o() >= 1 && thisPos.func_177956_o() <= 256) && this.fallTime <= 600)) {
                        if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.dropTreasureItems();
                        }
                        this.func_70106_y();
                    }
                } else {
                    BlockState stateAtPos = this.field_70170_p.func_180495_p(thisPos);
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (stateAtPos.func_177230_c() != Blocks.field_196603_bb) {
                        this.func_70106_y();
                        if (!this.dontSetBlock) {
                            int belowPileLevel;
                            SoundType treasureSoundType = fallTile.getSoundType((IWorldReader)this.field_70170_p, thisPos, (Entity)this);
                            boolean placedAnyTreasure = false;
                            boolean placedAllTreasure = false;
                            if (stateAtPos.func_177230_c() == fallTile.func_177230_c() && (belowPileLevel = ((Integer)stateAtPos.func_177229_b((Property)TreasurePileBlock.PILE_LEVEL)).intValue()) < 8) {
                                int fallingPileLevel;
                                for (fallingPileLevel = ((Integer)fallTile.func_177229_b((Property)TreasurePileBlock.PILE_LEVEL)).intValue(); fallingPileLevel > 0 && belowPileLevel < 8; --fallingPileLevel, ++belowPileLevel) {
                                }
                                this.field_70170_p.func_180501_a(thisPos, (BlockState)stateAtPos.func_206870_a((Property)TreasurePileBlock.PILE_LEVEL, (Comparable)Integer.valueOf(belowPileLevel)), 3);
                                thisPos = thisPos.func_177984_a();
                                stateAtPos = this.field_70170_p.func_180495_p(thisPos);
                                placedAnyTreasure = true;
                                if (fallingPileLevel <= 0) {
                                    placedAllTreasure = true;
                                    fallTile = Blocks.field_150350_a.func_176223_P();
                                } else {
                                    fallTile = (BlockState)fallTile.func_206870_a((Property)TreasurePileBlock.PILE_LEVEL, (Comparable)Integer.valueOf(fallingPileLevel));
                                }
                                this.setFallTile(fallTile);
                            }
                            if (!placedAllTreasure) {
                                boolean placeAt;
                                boolean replaceable = stateAtPos.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, thisPos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                                boolean canFallThrough = FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(thisPos.func_177977_b()));
                                boolean bl = placeAt = fallTile.func_196955_c((IWorldReader)this.field_70170_p, thisPos) && !canFallThrough;
                                if (replaceable && placeAt) {
                                    if (fallTile.func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(thisPos).func_206886_c() == Fluids.field_204546_a) {
                                        fallTile = (BlockState)fallTile.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                                    }
                                    if (this.field_70170_p.func_180501_a(thisPos, fallTile, 3)) {
                                        if (block instanceof TreasurePileBlock) {
                                            ((TreasurePileBlock)block).onEndFallingTreasure(this.field_70170_p, thisPos, fallTile, stateAtPos);
                                        }
                                        placedAnyTreasure = true;
                                    } else if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                        this.dropTreasureItems();
                                    }
                                } else if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                    this.dropTreasureItems();
                                }
                            }
                            if (placedAnyTreasure) {
                                this.field_70170_p.func_184133_a(null, thisPos, treasureSoundType.func_185841_e(), SoundCategory.BLOCKS, (treasureSoundType.func_185843_a() + 1.0f) / 2.0f, treasureSoundType.func_185847_b() * 0.8f);
                            }
                        } else if (block instanceof FallingBlock) {
                            // empty if block
                        }
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    private void dropTreasureItems() {
        Block.func_220075_c((BlockState)this.getFallTile(), (World)this.field_70170_p, (BlockPos)this.func_233580_cy_());
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.getFallTile()));
        nbt.func_74768_a("Time", this.fallTime);
        nbt.func_74757_a("DropItem", this.shouldDropItem);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.setFallTile(NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("BlockState")));
        this.fallTime = nbt.func_74762_e("Time");
        if (nbt.func_150297_b("DropItem", 99)) {
            this.shouldDropItem = nbt.func_74767_n("DropItem");
        }
        if (!this.isValidFallTile()) {
            this.setFallTile(((Block)LOTRBlocks.GOLD_TREASURE_PILE.get()).func_176223_P());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Immitating BlockState", (Object)this.getFallTile().toString());
    }

    public boolean func_184213_bq() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

