/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.ManEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.goal.HobbitSmokeGoal;
import lotr.common.entity.npc.ai.goal.NPCMeleeAttackGoal;
import lotr.common.entity.npc.data.NPCFoodPool;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.entity.npc.data.name.NPCNameGenerator;
import lotr.common.entity.npc.data.name.NPCNameGenerators;
import lotr.common.init.LOTRItems;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BreeManEntity
extends ManEntity {
    private static final SpawnEquipmentTable WEAPONS = SpawnEquipmentTable.of(LOTRItems.IRON_DAGGER, LOTRItems.BRONZE_DAGGER, Items.field_151036_c, LOTRItems.BRONZE_AXE, Items.field_151049_t);
    public static final String CARROT_EATER_NAME = "Peter Jackson";

    public BreeManEntity(EntityType<? extends BreeManEntity> type, World w) {
        super((EntityType<? extends ManEntity>)type, w);
    }

    @Override
    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.BREE;
    }

    @Override
    protected Goal createAttackGoal() {
        return new NPCMeleeAttackGoal(this, 1.3);
    }

    @Override
    protected void addNPCTargetingAI() {
        this.addNonAggressiveTargetingGoals();
    }

    @Override
    protected NPCFoodPool getEatPool() {
        return NPCFoodPools.BREE;
    }

    @Override
    protected NPCFoodPool getDrinkPool() {
        return NPCFoodPools.BREE_DRINK;
    }

    @Override
    protected void addConsumingGoals(int prio) {
        super.addConsumingGoals(prio);
        this.field_70714_bg.func_75776_a(prio, (Goal)new HobbitSmokeGoal(this, 12000));
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.clearIdleItem();
        if (this.personalInfo.isMale() && this.field_70146_Z.nextInt(2000) == 0) {
            this.personalInfo.setName(CARROT_EATER_NAME);
            this.npcItemsInv.setIdleItem(new ItemStack((IItemProvider)Items.field_151172_bF));
        }
        return spawnData;
    }
}

