/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.DunlendingEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.goal.NPCMeleeAttackGoal;
import lotr.common.entity.npc.data.NPCGenderProvider;
import lotr.common.init.LOTRItems;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class DunlendingWarriorEntity
extends DunlendingEntity {
    private static final SpawnEquipmentTable WEAPONS = SpawnEquipmentTable.of(Items.field_151040_l, LOTRItems.IRON_DAGGER, LOTRItems.IRON_SPEAR, Items.field_151036_c, LOTRItems.BRONZE_SWORD, LOTRItems.BRONZE_DAGGER, LOTRItems.BRONZE_SPEAR, LOTRItems.BRONZE_AXE);

    public DunlendingWarriorEntity(EntityType<? extends DunlendingWarriorEntity> type, World w) {
        super((EntityType<? extends DunlendingEntity>)type, w);
    }

    @Override
    protected NPCGenderProvider getGenderProvider() {
        return NPCGenderProvider.MALE;
    }

    @Override
    protected Goal createAttackGoal() {
        return new NPCMeleeAttackGoal(this, 1.6);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.setIdleItemsFromMeleeWeapons();
        this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)LOTRItems.DUNLENDING_BOOTS.get()));
        this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)LOTRItems.DUNLENDING_LEGGINGS.get()));
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)LOTRItems.DUNLENDING_CHESTPLATE.get()));
        if (this.field_70146_Z.nextInt(10) != 0) {
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)LOTRItems.DUNLENDING_HELMET.get()));
        }
        if (this.field_70146_Z.nextFloat() < 0.4f) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
        }
        return spawnData;
    }
}

