/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.config.LOTRConfig;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.AttackGoalsHolder;
import lotr.common.entity.npc.ai.goal.FriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.ai.goal.NPCMeleeAttackGoal;
import lotr.common.entity.npc.ai.goal.TalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.entity.npc.data.NPCFoodPool;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.entity.npc.data.NPCGenderProvider;
import lotr.common.entity.npc.data.name.NPCNameGenerator;
import lotr.common.entity.npc.data.name.NPCNameGenerators;
import lotr.common.init.LOTRAttributes;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRSoundEvents;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DwarfEntity
extends NPCEntity {
    private static final SpawnEquipmentTable WEAPONS = SpawnEquipmentTable.of(Items.field_151036_c, Items.field_151035_b, LOTRItems.IRON_DAGGER, LOTRItems.DWARVEN_AXE, LOTRItems.DWARVEN_PICKAXE, LOTRItems.DWARVEN_DAGGER);

    public DwarfEntity(EntityType<? extends DwarfEntity> type, World w) {
        super(type, w);
    }

    @Override
    protected NPCGenderProvider getGenderProvider() {
        return NPCGenderProvider.DWARF;
    }

    @Override
    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.DWARF;
    }

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return NPCEntity.registerBaseNPCAttributes().func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_((Attribute)LOTRAttributes.NPC_CONVERSATION_RANGE.get(), 6.0).func_233815_a_(Attributes.field_233820_c_, 0.4);
    }

    @Override
    protected void addNPCAI() {
        super.addNPCAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(3);
        this.field_70714_bg.func_75776_a(9, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(10, (Goal)new TalkToCurrentGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new FriendlyNPCConversationGoal(this, 5.0E-4f));
        this.field_70714_bg.func_75776_a(12, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.001f));
        this.field_70714_bg.func_75776_a(13, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(14, (Goal)new NPCEatGoal(this, this.getEatPool(), 6000));
        this.field_70714_bg.func_75776_a(14, (Goal)new NPCDrinkGoal(this, this.getDrinkPool(), 6000));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(16, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(17, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void initialiseAttackGoals(AttackGoalsHolder holder) {
        holder.setMeleeAttackGoal(this.createDwarfAttackGoal());
    }

    protected Goal createDwarfAttackGoal() {
        return new NPCMeleeAttackGoal(this, 1.3);
    }

    @Override
    protected void addNPCTargetingAI() {
        this.addAggressiveTargetingGoals();
    }

    protected NPCFoodPool getEatPool() {
        return NPCFoodPools.DWARF;
    }

    protected NPCFoodPool getDrinkPool() {
        return NPCFoodPools.DWARF_DRINK;
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.clearIdleItem();
        return spawnData;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return LOTRSoundEvents.DWARF_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return LOTRSoundEvents.DWARF_DEATH;
    }

    @Override
    protected SoundEvent getAttackSound() {
        return LOTRSoundEvents.DWARF_ATTACK;
    }

    @Override
    protected SoundEvent getKillSound() {
        return LOTRSoundEvents.DWARF_KILL;
    }

    protected float func_70647_i() {
        float f = super.func_70647_i();
        if (this.personalInfo.isFemale()) {
            f *= 1.2f;
        }
        return f;
    }

    @Override
    public boolean func_213380_a(IWorld iworld, SpawnReason reason) {
        return super.func_213380_a(iworld, reason) && (reason != SpawnReason.NATURAL || this.canDwarfSpawnHere());
    }

    protected boolean canDwarfSpawnHere() {
        if (this.field_70146_Z.nextInt(20) == 0) {
            return this.canDwarfSpawnAboveGround();
        }
        BlockPos pos = this.func_233580_cy_();
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151576_e && !this.field_70170_p.func_175710_j(pos);
    }

    protected boolean canDwarfSpawnAboveGround() {
        return true;
    }

    @Override
    public boolean useSmallArmsModel() {
        return (Boolean)LOTRConfig.CLIENT.dwarfWomenUseAlexModelStyle.get() != false && this.personalInfo.isFemale();
    }
}

