/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.config.LOTRConfig;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.AttackGoalsHolder;
import lotr.common.entity.npc.ai.StandardAttackModeUpdaters;
import lotr.common.entity.npc.ai.goal.FriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.ai.goal.TalkToCurrentGoal;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.entity.npc.data.NPCGenderProvider;
import lotr.common.entity.npc.data.name.NPCNameGenerator;
import lotr.common.entity.npc.data.name.NPCNameGenerators;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.world.spawning.NPCSpawnSettingsManager;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class OrcEntity
extends NPCEntity {
    protected boolean isOrcWeakInSun = true;

    public OrcEntity(EntityType<? extends OrcEntity> type, World w) {
        super(type, w);
        this.getNPCCombatUpdater().setAttackModeUpdater(StandardAttackModeUpdaters.meleeOnlyOrcWithBomb());
        this.spawnRequiresDarkness = true;
    }

    @Override
    protected NPCGenderProvider getGenderProvider() {
        return NPCGenderProvider.MALE;
    }

    @Override
    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.ORC;
    }

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return NPCEntity.registerBaseNPCAttributes().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    @Override
    protected void addNPCAI() {
        super.addNPCAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(4);
        this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new TalkToCurrentGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new FriendlyNPCConversationGoal(this, 2.0E-4f));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCEatGoal(this, NPCFoodPools.ORC, 6000));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCDrinkGoal(this, NPCFoodPools.ORC_DRINK, 6000));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void initialiseAttackGoals(AttackGoalsHolder holder) {
        holder.setMeleeAttackGoal(this.createOrcAttackGoal());
    }

    protected abstract Goal createOrcAttackGoal();

    @Override
    protected void addNPCTargetingAI() {
        int target = this.addAggressiveTargetingGoals();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isOrcWeakInSun && this.isOrcExposedToSun() && this.field_70173_aa % 20 == 0) {
            this.func_195064_c(new EffectInstance(Effects.field_76429_m, 200, -2));
            this.func_195064_c(new EffectInstance(Effects.field_76421_d, 200));
        }
    }

    private boolean isOrcExposedToSun() {
        BlockPos pos = this.func_233580_cy_();
        Biome biome = this.field_70170_p.func_226691_t_(pos);
        return this.field_70170_p.func_72935_r() && this.field_70170_p.func_175710_j(pos) && !NPCSpawnSettingsManager.getSpawnsForBiome(biome, (IWorld)this.field_70170_p).allowsDarknessSpawnsInDaytime();
    }

    protected SoundEvent func_184639_G() {
        return LOTRSoundEvents.ORC_AEUGH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return LOTRSoundEvents.ORC_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return LOTRSoundEvents.ORC_DEATH;
    }

    @Override
    public boolean useSmallArmsModel() {
        return (Boolean)LOTRConfig.CLIENT.orcWomenUseAlexModelStyle.get() != false && this.personalInfo.isFemale();
    }
}

