/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.ai.goal;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;

public class NPCRangedAttackGoal<E extends MobEntity>
extends Goal {
    private final E entity;
    private final Random rand;
    private final double moveSpeed;
    private int attackCooldown;
    private final float maxAttackDistanceSq;
    private int attackTime = -1;
    private static final int ATTACK_CHARGE_TIME = 20;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public NPCRangedAttackGoal(E entity, double moveSpeed, int attackCooldown, float maxAttackDistance) {
        this.entity = entity;
        this.rand = entity.func_70681_au();
        this.moveSpeed = moveSpeed;
        this.attackCooldown = attackCooldown;
        this.maxAttackDistanceSq = maxAttackDistance * maxAttackDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    protected Predicate<Item> testRangedWeapon() {
        return item -> item instanceof BowItem;
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() == null ? false : this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return this.entity.func_233634_a_(this.testRangedWeapon());
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isBowInMainhand();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entity.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.func_213395_q(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity target = this.entity.func_70638_az();
        if (target != null) {
            boolean wasSeeing;
            double dSq = this.entity.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)target);
            boolean bl = wasSeeing = this.seeTime > 0;
            if (canSee != wasSeeing) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (dSq <= (double)this.maxAttackDistanceSq && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)target, this.moveSpeed);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.rand.nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.rand.nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (dSq > (double)(this.maxAttackDistanceSq * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (dSq < (double)(this.maxAttackDistanceSq * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            }
            if (this.entity.func_184587_cr()) {
                int useCount;
                if (!canSee && this.seeTime < -60) {
                    this.entity.func_184602_cy();
                } else if (canSee && (useCount = this.entity.func_184612_cw()) >= 20) {
                    this.entity.func_184602_cy();
                    ((IRangedAttackMob)this.entity).func_82196_d(target, BowItem.func_185059_b((int)useCount));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.entity.func_184598_c(ProjectileHelper.getWeaponHoldingHand(this.entity, this.testRangedWeapon()));
            }
        }
    }
}

