/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.ai.goal;

import java.util.Random;
import lotr.common.entity.npc.ai.goal.SkyWatchingGoal;
import lotr.common.util.LOTRUtil;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class StargazingGoal
extends SkyWatchingGoal {
    private Vector3d currentStargazeTarget;
    private int gazeHereTick;

    public StargazingGoal(MobEntity entity, float chance) {
        super(entity, chance);
    }

    @Override
    protected boolean shouldStartWatching() {
        Vector3d target;
        if (this.isNightTime() && this.canSeeStargazeTarget(target = this.getRandomStargazeTarget())) {
            this.currentStargazeTarget = target;
            this.gazeHereTick = this.getCurrentGazeDuration();
            return true;
        }
        return false;
    }

    private boolean isNightTime() {
        float sunCycle = this.world.func_242415_f(1.0f);
        return sunCycle > 0.26f && sunCycle < 0.74f;
    }

    @Override
    protected Vector3d getCurrentWatchTarget() {
        return this.currentStargazeTarget;
    }

    private Vector3d getRandomStargazeTarget() {
        this.world.func_217381_Z().func_76320_a("getRandomStargazeTarget");
        Vector3d eyePos = this.entity.func_174824_e(1.0f);
        Vector3d skyVector = new Vector3d(0.0, 300.0, 0.0);
        float randPitch = (float)Math.toRadians(MathHelper.func_151240_a((Random)this.rand, (float)-40.0f, (float)40.0f));
        float randYaw = this.rand.nextFloat() * (float)Math.PI * 2.0f;
        skyVector = skyVector.func_178789_a(randPitch).func_178785_b(randYaw);
        Vector3d skyPos = eyePos.func_178787_e(skyVector);
        this.world.func_217381_Z().func_76319_b();
        return skyPos;
    }

    private boolean canSeeStargazeTarget(Vector3d target) {
        this.world.func_217381_Z().func_76320_a("canSeeStargazeTarget");
        boolean canSee = this.canSeeSkyWatchTarget(target);
        this.world.func_217381_Z().func_76319_b();
        return canSee;
    }

    @Override
    protected boolean recheckShouldContinueWatching() {
        return this.isNightTime() && this.canSeeStargazeTarget(this.currentStargazeTarget);
    }

    @Override
    protected int getWatchingDuration() {
        return LOTRUtil.secondsToTicks(10 + this.entity.func_70681_au().nextInt(50));
    }

    private int getCurrentGazeDuration() {
        return LOTRUtil.secondsToTicks(4 + this.entity.func_70681_au().nextInt(12));
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        --this.gazeHereTick;
        if (this.gazeHereTick <= 0) {
            this.currentStargazeTarget = this.getRandomStargazeTarget();
            this.gazeHereTick = this.getCurrentGazeDuration();
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.currentStargazeTarget = null;
        this.gazeHereTick = 0;
    }
}

