/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.entity.npc.data.NPCEntitySettings;
import lotr.common.entity.npc.data.NPCEntitySettingsMap;
import lotr.common.fac.Faction;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketNPCEntitySettings;
import lotr.common.resources.InstancedJsonReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class NPCEntitySettingsManager
extends InstancedJsonReloadListener {
    private static final String ENTITY_SETTINGS_FOLDER = "npcs/entity_settings";
    private static final NPCEntitySettingsManager CLIENT_INSTANCE = new NPCEntitySettingsManager(LogicalSide.CLIENT);
    private static final NPCEntitySettingsManager SERVER_INSTANCE = new NPCEntitySettingsManager(LogicalSide.SERVER);
    private NPCEntitySettingsMap currentLoadedEntitySettings;

    private NPCEntitySettingsManager(LogicalSide side) {
        super(ENTITY_SETTINGS_FOLDER, "NPCEntitySettings", side);
    }

    public static NPCEntitySettingsManager clientInstance() {
        return CLIENT_INSTANCE;
    }

    public static NPCEntitySettingsManager serverInstance() {
        return SERVER_INSTANCE;
    }

    public static NPCEntitySettingsManager sidedInstance(IWorldReader world) {
        return !world.func_201670_d() ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public static NPCEntitySettingsManager sidedInstance(LogicalSide side) {
        return side == LogicalSide.SERVER ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public void loadClientEntitySettingsFromServer(IResourceManager resMgr, NPCEntitySettingsMap settings) {
        this.currentLoadedEntitySettings = settings;
        this.logEntitySettingsLoad("Loaded clientside NPC entity settings from server", this.currentLoadedEntitySettings);
    }

    public NPCEntitySettingsMap getCurrentLoadedEntitySettings() {
        return this.currentLoadedEntitySettings;
    }

    public static NPCEntitySettings getEntityTypeSettings(Entity entity) {
        return NPCEntitySettingsManager.sidedInstance((IWorldReader)entity.field_70170_p).getCurrentLoadedEntitySettings().getEntityTypeSettings(entity.func_200600_R());
    }

    public static Faction getEntityTypeFaction(Entity entity) {
        return NPCEntitySettingsManager.getEntityTypeSettings(entity).getAssignedFaction((IWorldReader)entity.field_70170_p);
    }

    private void logEntitySettingsLoad(String prefix, NPCEntitySettingsMap settings) {
        LOTRLog.info("%s - %d entity type settings", prefix, settings.getSize());
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager serverResMgr, IProfiler profiler) {
        this.currentLoadedEntitySettings = this.loadEntitySettingsFromJsons(serverResMgr, jsons);
        this.logEntitySettingsLoad("Loaded serverside NPC entity settings", this.currentLoadedEntitySettings);
    }

    private NPCEntitySettingsMap loadEntitySettingsFromJsons(IResourceManager resMgr, Map<ResourceLocation, JsonElement> entityTypeJsons) {
        HashMap entityTypeMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entityTypeJsons.entrySet()) {
            ResourceLocation res = entry.getKey();
            JsonObject entityTypeJson = entry.getValue().getAsJsonObject();
            try {
                EntityType<?> entityType = NPCEntitySettingsManager.lookupEntityTypeByName(res);
                if (entityType == null) {
                    LOTRLog.error("Failed to load NPC entity settings for %s - no such entity type exists in the game!", res);
                    continue;
                }
                NPCEntitySettings entityTypeSettings = NPCEntitySettings.read(entityType, entityTypeJson);
                if (entityTypeSettings == null) continue;
                entityTypeMap.put(entityType, entityTypeSettings);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load NPC entity settings for %s from file", res);
                e.printStackTrace();
            }
        }
        return new NPCEntitySettingsMap(entityTypeMap);
    }

    public void sendEntitySettingsToPlayer(ServerPlayerEntity player) {
        SPacketNPCEntitySettings packet = new SPacketNPCEntitySettings(this.currentLoadedEntitySettings);
        LOTRPacketHandler.sendTo(packet, player);
    }

    public static EntityType<?> lookupEntityTypeByName(ResourceLocation name) {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(name);
    }
}

