/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

import java.util.HashMap;
import java.util.Map;
import lotr.common.data.DataUtil;
import lotr.common.entity.npc.data.NPCEntitySettings;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.tuple.Pair;

public class NPCEntitySettingsMap {
    private final Map<EntityType<?>, NPCEntitySettings> entityTypeSettingsMap;

    public NPCEntitySettingsMap(Map<EntityType<?>, NPCEntitySettings> map) {
        this.entityTypeSettingsMap = map;
    }

    public static NPCEntitySettingsMap read(PacketBuffer buf) {
        HashMap entityTypeSettingsMap = DataUtil.readNewMapFromBuffer(buf, HashMap::new, () -> {
            NPCEntitySettings settings = NPCEntitySettings.read(buf);
            return Pair.of(settings.getEntityType(), (Object)settings);
        });
        return new NPCEntitySettingsMap(entityTypeSettingsMap);
    }

    public void write(PacketBuffer buf) {
        DataUtil.writeMapToBuffer(buf, this.entityTypeSettingsMap, (entityType, settings) -> settings.write(buf));
    }

    public NPCEntitySettings getEntityTypeSettings(EntityType<?> type) {
        return this.entityTypeSettingsMap.getOrDefault(type, NPCEntitySettings.createEmptyFallbackSettings(type));
    }

    public int getSize() {
        return this.entityTypeSettingsMap.size();
    }
}

