/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

public enum PersonalityTrait {
    PROUD("proud", "modest"),
    BRAVE("brave", "nervous"),
    CALM("calm", "anxious"),
    POLITE("polite", "rough"),
    FRIENDLY("friendly", "rude"),
    STRANGE("strange", "normal"),
    LOUD("loud", "quiet"),
    CLEVER("clever", "stupid"),
    WISE("wise", "insane"),
    EXCITABLE("excitable", "dull");

    private final String mainName;
    private final String oppositeName;
    private final int networkID;

    private PersonalityTrait(String s, String s1) {
        this.mainName = s;
        this.oppositeName = s1;
        this.networkID = this.ordinal();
    }

    public String getMainName() {
        return this.mainName;
    }

    public String getOppositeName() {
        return this.oppositeName;
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public static PersonalityTrait fromMainName(String name) {
        for (PersonalityTrait trait : PersonalityTrait.values()) {
            if (!trait.mainName.equalsIgnoreCase(name)) continue;
            return trait;
        }
        return null;
    }

    public static PersonalityTrait fromOppositeName(String name) {
        for (PersonalityTrait trait : PersonalityTrait.values()) {
            if (!trait.oppositeName.equalsIgnoreCase(name)) continue;
            return trait;
        }
        return null;
    }

    public static PersonalityTrait fromNetworkID(int id) {
        for (PersonalityTrait trait : PersonalityTrait.values()) {
            if (trait.networkID != id) continue;
            return trait;
        }
        return null;
    }
}

