/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.LOTRLog;
import lotr.common.data.DataUtil;
import lotr.common.entity.npc.data.PersonalityTrait;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;

public class PersonalityTraits {
    private final Set<PersonalityTrait> traits;

    private PersonalityTraits(Set<PersonalityTrait> traits) {
        this.traits = traits;
    }

    public static PersonalityTraits of(Set<PersonalityTrait> traits) {
        return new PersonalityTraits(traits);
    }

    public boolean hasTrait(PersonalityTrait trait) {
        return this.traits.contains((Object)trait);
    }

    public boolean hasOppositeTrait(PersonalityTrait trait) {
        return !this.hasTrait(trait);
    }

    public String toString() {
        return String.format("PersonalityTraits[%s]", Stream.of(PersonalityTrait.values()).sorted().map(trait -> this.hasTrait((PersonalityTrait)((Object)trait)) ? trait.getMainName() : trait.getOppositeName()).collect(Collectors.joining(", ")));
    }

    public void save(CompoundNBT nbt) {
        nbt.func_218657_a("Traits", (INBT)DataUtil.saveCollectionAsPrimitiveListNBT(this.traits, trait -> StringNBT.func_229705_a_((String)trait.getMainName())));
    }

    public static PersonalityTraits load(CompoundNBT nbt) {
        EnumSet<PersonalityTrait> traits = EnumSet.noneOf(PersonalityTrait.class);
        DataUtil.loadCollectionFromPrimitiveListNBT(traits, nbt.func_150295_c("Traits", 8), ListNBT::func_150307_f, name -> {
            PersonalityTrait trait = PersonalityTrait.fromMainName(name);
            if (trait == null) {
                LOTRLog.warn("Loaded nonexistent personality trait %s", name);
            }
            return trait;
        });
        return PersonalityTraits.of(traits);
    }

    public void write(PacketBuffer buf) {
        DataUtil.writeCollectionToBuffer(buf, this.traits, trait -> buf.func_150787_b(trait.getNetworkID()));
    }

    public static PersonalityTraits read(PacketBuffer buf) {
        EnumSet<PersonalityTrait> traits = EnumSet.noneOf(PersonalityTrait.class);
        DataUtil.fillCollectionFromBuffer(buf, traits, () -> {
            int id = buf.func_150792_a();
            PersonalityTrait trait = PersonalityTrait.fromNetworkID(id);
            if (trait == null) {
                LOTRLog.warn("Received nonexistent personality trait ID %d from server", id);
            }
            return trait;
        });
        return PersonalityTraits.of(traits);
    }
}

