/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class SuppliableItemTable {
    private final List<Supplier<ItemStack>> itemSupplierList = new ArrayList<Supplier<ItemStack>>();

    public SuppliableItemTable(Object ... items) {
        for (Object item : items) {
            if (item instanceof IItemProvider) {
                this.itemSupplierList.add(() -> new ItemStack((IItemProvider)item));
                continue;
            }
            if (item instanceof Supplier) {
                this.itemSupplierList.add(() -> {
                    Object supplied = ((Supplier)item).get();
                    if (supplied instanceof IItemProvider) {
                        return new ItemStack((IItemProvider)supplied);
                    }
                    if (supplied instanceof ItemStack) {
                        return (ItemStack)supplied;
                    }
                    throw new IllegalArgumentException(String.format("DEVELOPMENT ERROR! Unacceptable Supplier-supplied type %s in %s constructor", supplied, this.getClass().getName()));
                });
                continue;
            }
            throw new IllegalArgumentException(String.format("DEVELOPMENT ERROR! Unacceptable object type %s in %s constructor", item, this.getClass().getName()));
        }
    }

    public final ItemStack getRandomItem(Random random) {
        return this.itemSupplierList.get(random.nextInt(this.itemSupplierList.size())).get();
    }

    public final ItemStack getRandomItem(Random random, Predicate<ItemStack> filter) {
        List matchingItems = this.itemSupplierList.stream().map(Supplier::get).filter(filter).collect(Collectors.toList());
        return (ItemStack)matchingItems.get(random.nextInt(matchingItems.size()));
    }
}

