/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data.name;

import java.util.Random;
import lotr.common.entity.npc.data.name.NPCNameGenerator;
import lotr.common.entity.npc.data.name.SimpleGenderedNameGenerator;
import lotr.common.entity.npc.data.name.SimpleNameGenerator;
import net.minecraft.util.ResourceLocation;

public class SurnamedNameGenerator
implements NPCNameGenerator {
    private final NPCNameGenerator forenameGenerator;
    private final NPCNameGenerator surnameGenerator;
    private final float surnameChance;
    private static final float DEFAULT_SURNAME_CHANCE = 1.0f;

    public SurnamedNameGenerator(NPCNameGenerator forenameGenerator, NPCNameGenerator surnameGenerator, float surnameChance) {
        this.forenameGenerator = forenameGenerator;
        this.surnameGenerator = surnameGenerator;
        this.surnameChance = surnameChance;
    }

    public SurnamedNameGenerator(NPCNameGenerator forenameGenerator, NPCNameGenerator surnameGenerator) {
        this(forenameGenerator, surnameGenerator, 1.0f);
    }

    public SurnamedNameGenerator(ResourceLocation maleForename, ResourceLocation femaleForename, ResourceLocation surname, float surnameChance) {
        this(new SimpleGenderedNameGenerator(maleForename, femaleForename), new SimpleNameGenerator(surname), surnameChance);
    }

    public SurnamedNameGenerator(ResourceLocation maleForename, ResourceLocation femaleForename, ResourceLocation surname) {
        this(maleForename, femaleForename, surname, 1.0f);
    }

    @Override
    public String generateName(Random rand, boolean male) {
        String forename = this.forenameGenerator.generateName(rand, male);
        if (rand.nextFloat() < this.surnameChance) {
            return String.format("%s %s", forename, this.surnameGenerator.generateName(rand, male));
        }
        return forename;
    }
}

