/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.event;

import java.util.Random;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.entity.npc.GaladhrimWarriorEntity;
import lotr.common.fac.FactionPointer;
import lotr.common.fac.FactionPointers;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRTags;
import lotr.common.speech.EventSpeechbanks;
import lotr.common.world.biome.LOTRBiomeWrapper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class BreakMallornResponse {
    private static final FactionPointer FACTION = FactionPointers.LOTHLORIEN;

    public void handleBlockBreak(World world, PlayerEntity player, BlockPos pos, BlockState state) {
        if (!world.field_72995_K && state.func_235714_a_(LOTRTags.Blocks.BREAK_MALLORN_RESPONSES) && !player.field_71075_bZ.field_75098_d) {
            ServerWorld sWorld = (ServerWorld)world;
            Random rand = world.field_73012_v;
            LOTRBiomeWrapper biomeWrapper = LOTRBiomes.getWrapperFor(world.func_226691_t_(pos), (IWorld)world);
            LOTRPlayerData pd = LOTRLevelData.getSidedData(player);
            if (rand.nextInt(3) == 0 && biomeWrapper.hasBreakMallornResponse() && pd.getAlignmentData().getAlignment(FACTION) < 0.0f) {
                int elves = 2 + world.field_73012_v.nextInt(4);
                boolean sentMessage = false;
                for (int l = 0; l < elves; ++l) {
                    GaladhrimWarriorEntity warrior = this.spawnWarrior(sWorld, rand, player, pos);
                    if (warrior == null || sentMessage) continue;
                    warrior.sendSpeechTo((ServerPlayerEntity)player, EventSpeechbanks.GALADHRIM_WARRIOR_DEFEND_MALLORN);
                    sentMessage = true;
                }
            }
        }
    }

    private GaladhrimWarriorEntity spawnWarrior(ServerWorld world, Random rand, PlayerEntity player, BlockPos pos) {
        int z;
        int y;
        GaladhrimWarriorEntity warrior = (GaladhrimWarriorEntity)((EntityType)LOTREntities.GALADHRIM_WARRIOR.get()).func_200721_a((World)world);
        int range = 6;
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_()) + MathHelper.func_76136_a((Random)rand, (int)(-range), (int)range);
        BlockPos topPos = new BlockPos(x, y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z = MathHelper.func_76128_c((double)player.func_226281_cx_()) + MathHelper.func_76136_a((Random)rand, (int)(-range), (int)range)), z);
        if (world.func_180495_p(topPos.func_177977_b()).func_224755_d((IBlockReader)world, topPos.func_177977_b(), Direction.UP) && !world.func_180495_p(topPos).func_215686_e((IBlockReader)world, topPos) && !world.func_180495_p(topPos.func_177984_a()).func_215686_e((IBlockReader)world, topPos.func_177984_a())) {
            warrior.func_70012_b((double)x + 0.5, y, (double)z + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            if (warrior.func_213380_a((IWorld)world, SpawnReason.EVENT)) {
                warrior.spawnRidingHorse = false;
                warrior.func_213386_a((IServerWorld)world, world.func_175649_E(warrior.func_233580_cy_()), SpawnReason.EVENT, null, null);
                world.func_242417_l((Entity)warrior);
                warrior.setDefendingTree();
                warrior.func_70624_b((LivingEntity)player);
                return warrior;
            }
        }
        return null;
    }
}

