/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lotr.common.config.LOTRConfig;
import lotr.common.data.LOTRLevelData;
import lotr.common.entity.item.RingPortalEntity;
import lotr.common.init.LOTRDimensions;
import lotr.common.time.LOTRDate;
import lotr.common.time.LOTRTime;
import lotr.common.world.RingPortalTeleporter;
import lotr.common.world.spawning.RenewedNPCSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class LOTRTickHandlerServer {
    private Map<Entity, RingPortalEntity> ringPortalTransfers = new HashMap<Entity, RingPortalEntity>();
    private Map<Entity, Integer> ringPortalPlayerTicks = new HashMap<Entity, Integer>();
    public static final int RING_PORTAL_PLAYER_TIME = 100;

    public LOTRTickHandlerServer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerWorld world = (ServerWorld)event.world;
            TickEvent.Phase phase = event.phase;
            LOTRLevelData levelData = LOTRLevelData.serverInstance();
            if (phase == TickEvent.Phase.START && LOTRDimensions.isDimension((World)world, (RegistryKey<World>)World.field_234918_g_)) {
                if (levelData.needsLoad()) {
                    levelData.load(world);
                }
                if (LOTRTime.needsLoad()) {
                    LOTRTime.load(world);
                }
            }
            if (phase == TickEvent.Phase.END) {
                if (LOTRDimensions.isDimension((World)world, (RegistryKey<World>)World.field_234918_g_)) {
                    if (levelData.anyDataNeedsSave()) {
                        levelData.save(world);
                    }
                    if (world.func_82737_E() % 600L == 0L) {
                        levelData.save(world);
                    }
                    if (world.func_82737_E() % (long)((Integer)LOTRConfig.SERVER.playerDataClearingInterval.get()).intValue() == 0L) {
                        levelData.saveAndClearUnusedPlayerData(world);
                    }
                } else if (LOTRDimensions.isDimension((World)world, LOTRDimensions.MIDDLE_EARTH_WORLD_KEY)) {
                    LOTRTime.updateTime((World)world);
                    LOTRDate.updateDate(world);
                    RenewedNPCSpawner.getForWorld(world).runSpawning(world);
                    if (world.func_82737_E() % 20L == 0L) {
                        for (PlayerEntity player : world.func_217369_A()) {
                            levelData.sendPlayerLocationsToPlayer(player, world);
                        }
                    }
                }
                HashSet<Object> removes = new HashSet<Object>();
                for (Map.Entry<Entity, RingPortalEntity> entry : this.ringPortalTransfers.entrySet()) {
                    Entity e = entry.getKey();
                    RingPortalEntity portal = entry.getValue();
                    if (!e.func_70089_S() || e.field_70170_p == null) {
                        removes.add(e);
                        continue;
                    }
                    if (e.field_70170_p != world) continue;
                    boolean inPortal = LOTRTickHandlerServer.checkInRingPortal(e);
                    if (e instanceof PlayerEntity) {
                        PlayerEntity player = (PlayerEntity)e;
                        if (inPortal) {
                            int i = this.ringPortalPlayerTicks.getOrDefault(player, 0);
                            this.ringPortalPlayerTicks.put((Entity)player, ++i);
                            if (i < 100) continue;
                            RingPortalTeleporter.transferEntity(world, (Entity)player, Optional.of(portal), true);
                            this.ringPortalPlayerTicks.remove(player);
                            removes.add(player);
                            continue;
                        }
                        this.ringPortalPlayerTicks.remove(player);
                        continue;
                    }
                    if (inPortal) {
                        RingPortalTeleporter.transferEntity(world, e, Optional.of(portal), true);
                    }
                    removes.add(e);
                }
                removes.forEach(this.ringPortalTransfers::remove);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            ServerWorld world = player.func_71121_q();
            TickEvent.Phase phase = event.phase;
            if (phase == TickEvent.Phase.END) {
                LOTRLevelData.serverInstance().getData((PlayerEntity)player).onUpdate(player, world);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        ServerWorld sWorld;
        boolean isCompleteGameUnload;
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld && (isCompleteGameUnload = LOTRDimensions.isDimension((World)(sWorld = (ServerWorld)world), (RegistryKey<World>)World.field_234918_g_))) {
            this.ringPortalTransfers.clear();
            this.ringPortalPlayerTicks.clear();
        }
    }

    public void prepareRingPortal(Entity entity, RingPortalEntity portal) {
        if (!this.ringPortalTransfers.containsKey(entity)) {
            this.ringPortalTransfers.put(entity, portal);
        }
    }

    public static boolean checkInRingPortal(Entity entity) {
        if (entity instanceof RingPortalEntity || entity.func_184218_aH()) {
            return false;
        }
        double searchRange = 8.0;
        List portals = entity.field_70170_p.func_217357_a(RingPortalEntity.class, entity.func_174813_aQ().func_72321_a(searchRange, searchRange, searchRange));
        boolean inPortal = false;
        for (RingPortalEntity portal : portals) {
            if (!portal.func_174813_aQ().func_72326_a(entity.func_174813_aQ())) continue;
            return true;
        }
        return false;
    }
}

