/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lotr.common.LOTRMod;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerMessageType;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.fac.AlignmentPredicates;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionPointers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;

public class EntityFactionHelper {
    public static Faction getFaction(Entity entity) {
        if (entity instanceof NPCEntity) {
            return ((NPCEntity)entity).getFaction();
        }
        return NPCEntitySettingsManager.getEntityTypeFaction(entity);
    }

    public static boolean isCivilian(Entity entity) {
        return entity instanceof NPCEntity && ((NPCEntity)entity).isCivilianNPC();
    }

    public static boolean canEntityCauseDamageToTarget(LivingEntity attacker, Entity target, boolean warnFriendlyFireForPlayer) {
        if (attacker instanceof PlayerEntity) {
            return EntityFactionHelper.canPlayerCauseDamageToTarget((PlayerEntity)attacker, target, warnFriendlyFireForPlayer);
        }
        return EntityFactionHelper.canNonPlayerEntityCauseDamageToTarget(attacker, target, false);
    }

    public static boolean canPlayerCauseDamageToTarget(PlayerEntity attacker, Entity target, boolean warnFriendlyFire) {
        Entity alignedTarget;
        LOTRPlayerData playerData = LOTRLevelData.getSidedData(attacker);
        boolean friendlyFire = false;
        boolean friendlyFireEnabled = playerData.getAlignmentData().isFriendlyFireEnabled();
        if (target instanceof PlayerEntity && target != attacker) {
            PlayerEntity playerEntity = (PlayerEntity)target;
        }
        Entity entity = alignedTarget = EntityFactionHelper.isAlignedToSomeFaction(target) ? target : (Entity)target.func_184188_bt().stream().filter(rider -> EntityFactionHelper.isAlignedToSomeFaction(rider)).findFirst().orElse(null);
        if (alignedTarget != null) {
            Faction targetFaction = EntityFactionHelper.getFaction(alignedTarget);
            if (alignedTarget instanceof MobEntity && !LOTRMod.PROXY.getSidedAttackTarget((MobEntity)alignedTarget).filter((Predicate<LivingEntity>)Predicates.equalTo((Object)attacker)).isPresent() && playerData.getAlignmentData().hasAlignment(targetFaction, AlignmentPredicates.POSITIVE)) {
                friendlyFire = true;
            }
        }
        if (!friendlyFireEnabled && friendlyFire) {
            if (warnFriendlyFire && !attacker.field_70170_p.field_72995_K) {
                playerData.getMessageData().sendMessageIfNotReceived(PlayerMessageType.FRIENDLY_FIRE);
            }
            return false;
        }
        return true;
    }

    private static boolean isAlignedToSomeFaction(Entity entity) {
        return !FactionPointers.UNALIGNED.matches(EntityFactionHelper.getFaction(entity));
    }

    public static boolean canNonPlayerEntityCauseDamageToTarget(LivingEntity attacker, Entity target, boolean isPlayerDirectedAttack) {
        Faction attackerFaction = EntityFactionHelper.getFaction((Entity)attacker);
        if (attacker instanceof NPCEntity) {
            NPCEntity nPCEntity = (NPCEntity)attacker;
        }
        Optional<LivingEntity> attackerTarget = EntityFactionHelper.getEntityAttackTarget(attacker);
        Predicate<Entity> isNotAttackerTarget = e -> !attackerTarget.filter((Predicate<LivingEntity>)Predicates.equalTo((Object)e)).isPresent();
        Predicate<Entity> shouldNotHitNpc = isNotAttackerTarget.and(e -> attackerFaction.isGoodRelation(EntityFactionHelper.getFaction(e)));
        Predicate<Entity> shouldNotHitPlayer = isNotAttackerTarget.and(e -> e instanceof PlayerEntity && LOTRLevelData.getSidedData((PlayerEntity)e).getAlignmentData().hasAlignment(attackerFaction, AlignmentPredicates.POSITIVE));
        if (isNotAttackerTarget.test(target)) {
            if (shouldNotHitNpc.test(target)) {
                return false;
            }
            if (EntityFactionHelper.isListNonemptyAndAllMatch(target.func_184188_bt(), shouldNotHitNpc)) {
                return false;
            }
            if (!isPlayerDirectedAttack) {
                if (shouldNotHitPlayer.test(target)) {
                    return false;
                }
                if (EntityFactionHelper.isListNonemptyAndAllMatch(target.func_184188_bt(), shouldNotHitPlayer)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static Optional<LivingEntity> getEntityAttackTarget(LivingEntity entity) {
        if (entity instanceof MobEntity) {
            return LOTRMod.PROXY.getSidedAttackTarget((MobEntity)entity);
        }
        return Optional.empty();
    }

    private static <T> boolean isListNonemptyAndAllMatch(List<T> list, Predicate<T> predicate) {
        return !list.isEmpty() && list.stream().allMatch(predicate);
    }
}

