/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import java.util.Optional;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;

public class FactionPointer {
    private final ResourceLocation name;

    private FactionPointer(ResourceLocation name) {
        this.name = name;
    }

    public static FactionPointer of(ResourceLocation name) {
        return new FactionPointer(name);
    }

    public static FactionPointer of(String namespace, String path) {
        return FactionPointer.of(new ResourceLocation(namespace, path));
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getNameString() {
        return this.getName().toString();
    }

    public Optional<Faction> resolveFaction(IWorldReader world) {
        FactionSettings currentSettings = FactionSettingsManager.sidedInstance(world).getCurrentLoadedFactions();
        if (currentSettings == null) {
            LOTRLog.error("Tried to call a FactionPointer (%s) outside the context of a currently loaded faction list");
            return Optional.empty();
        }
        return this.resolveFaction(currentSettings);
    }

    public Optional<Faction> resolveFaction(FactionSettings currentSettings) {
        return Optional.ofNullable(currentSettings.getFactionByPointer(this));
    }

    public boolean matches(Faction fac) {
        return this.getName().equals((Object)fac.getName());
    }
}

