/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import java.util.Map;
import lotr.common.util.LOTRUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum FactionRelation {
    ALLY("ally"),
    FRIEND("friend"),
    NEUTRAL("neutral"),
    ENEMY("enemy"),
    MORTAL_ENEMY("mortal_enemy");

    private static final Map<String, FactionRelation> NAME_LOOKUP;
    private static final Map<Integer, FactionRelation> ID_LOOKUP;
    public final String codeName;
    public final int networkID;

    private FactionRelation(String name) {
        this.codeName = name;
        this.networkID = this.ordinal();
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(String.format("factionrelation.%s.%s", "lotr", this.codeName));
    }

    public static FactionRelation forName(String name) {
        return NAME_LOOKUP.get(name);
    }

    public static FactionRelation forNetworkID(int id) {
        return ID_LOOKUP.get(id);
    }

    static {
        NAME_LOOKUP = LOTRUtil.createKeyedEnumMap((Enum[])FactionRelation.values(), relation -> relation.codeName);
        ID_LOOKUP = LOTRUtil.createKeyedEnumMap((Enum[])FactionRelation.values(), relation -> relation.networkID);
    }
}

