/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import java.util.Map;
import lotr.common.util.LOTRUtil;
import net.minecraft.util.ResourceLocation;

public enum FactionType {
    FREE_PEOPLE("free_people"),
    ELF("elf"),
    MAN("man"),
    DWARF("dwarf"),
    ORC("orc"),
    TROLL("troll"),
    TREE("tree");

    private static final Map<ResourceLocation, FactionType> NAME_LOOKUP;
    private static final Map<Integer, FactionType> ID_LOOKUP;
    public final ResourceLocation namespacedID;
    public final int networkID;

    private FactionType(String name) {
        this.namespacedID = new ResourceLocation("lotr", name);
        this.networkID = this.ordinal();
    }

    public static FactionType forName(ResourceLocation name) {
        return NAME_LOOKUP.get(name);
    }

    public static FactionType forNetworkID(int id) {
        return ID_LOOKUP.get(id);
    }

    static {
        NAME_LOOKUP = LOTRUtil.createKeyedEnumMap((Enum[])FactionType.values(), type -> type.namespacedID);
        ID_LOOKUP = LOTRUtil.createKeyedEnumMap((Enum[])FactionType.values(), type -> type.networkID);
    }
}

