/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lotr.common.LOTRLog;
import lotr.common.dim.LOTRDimensionType;
import lotr.common.dim.MiddleEarthDimensionType;
import lotr.common.fac.Faction;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.provider.MiddleEarthBiomeProvider;
import lotr.common.world.gen.MiddleEarthChunkGenerator;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;
import net.minecraft.world.server.ServerWorld;

public class LOTRDimensions {
    public static final ResourceLocation MIDDLE_EARTH_ID = new ResourceLocation("lotr", "middle_earth");
    public static final LOTRDimensionType MIDDLE_EARTH_DIMTYPE = LOTRDimensions.dispatchModDimensionType(MIDDLE_EARTH_ID);
    public static final RegistryKey<DimensionType> MIDDLE_EARTH_DIMTYPE_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)MIDDLE_EARTH_ID);
    public static final RegistryKey<Dimension> MIDDLE_EARTH_DIM_KEY = LOTRDimensions.createDimensionKey(MIDDLE_EARTH_ID);
    public static final RegistryKey<World> MIDDLE_EARTH_WORLD_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)MIDDLE_EARTH_DIM_KEY.func_240901_a_());
    private static Set<RegistryKey<Dimension>> addedDimensionKeys;
    public static final RegistryKey<DimensionSettings> MIDDLE_EARTH_DIMSETTINGS_KEY;
    public static final DimensionSettings MIDDLE_EARTH_DIMSETTINGS;

    public static LOTRDimensionType dispatchModDimensionType(ResourceLocation dimensionId) {
        if (dimensionId.equals((Object)MIDDLE_EARTH_ID)) {
            return new MiddleEarthDimensionType(MIDDLE_EARTH_ID);
        }
        throw new IllegalArgumentException("Dimension ID " + dimensionId + " is not a known LOTR mod dimension and cannot be dispatched to a LOTRDimensionType!");
    }

    private static RegistryKey<Dimension> createDimensionKey(ResourceLocation res) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)res);
        if (addedDimensionKeys == null) {
            addedDimensionKeys = new HashSet<RegistryKey<Dimension>>();
        }
        addedDimensionKeys.add((RegistryKey<Dimension>)key);
        return key;
    }

    public static boolean isAddedDimension(RegistryKey<Dimension> key) {
        return addedDimensionKeys.contains(key);
    }

    public static Set<RegistryKey<Dimension>> viewAddedDimensions() {
        return ImmutableSet.copyOf(addedDimensionKeys);
    }

    public static void registerDimensionTypes(MutableRegistry<DimensionType> dimTypeReg) {
        dimTypeReg.func_218381_a(MIDDLE_EARTH_DIMTYPE_KEY, (Object)MIDDLE_EARTH_DIMTYPE, Lifecycle.stable());
    }

    public static void registerWorldDimensions(SimpleRegistry<Dimension> dimReg, Registry<DimensionType> dimTypeReg, Registry<Biome> biomeReg, Registry<DimensionSettings> dimSettingsReg, long seed) {
        for (RegistryKey<Dimension> modDimension : LOTRDimensions.viewAddedDimensions()) {
            LOTRDimensions.addSpecificDimensionToWorldRegistry(modDimension, dimReg, dimTypeReg, biomeReg, dimSettingsReg, seed);
        }
    }

    public static void addSpecificDimensionToWorldRegistry(RegistryKey<Dimension> dimKey, SimpleRegistry<Dimension> dimReg, Registry<DimensionType> dimTypeReg, Registry<Biome> biomeReg, Registry<DimensionSettings> dimSettingsReg, long seed) {
        if (!dimKey.equals(MIDDLE_EARTH_DIM_KEY)) {
            throw new IllegalArgumentException("Coding error! LOTR mod somehow tried to add an unknown dimension (" + dimKey.func_240901_a_() + ") to the world registry - it isn't one of ours!");
        }
        dimReg.func_218381_a(dimKey, (Object)new Dimension(() -> (DimensionType)dimTypeReg.func_243576_d(MIDDLE_EARTH_DIMTYPE_KEY), LOTRDimensions.createMiddleEarthChunkGenerator(biomeReg, dimSettingsReg, seed)), Lifecycle.stable());
    }

    private static ChunkGenerator createMiddleEarthChunkGenerator(Registry<Biome> biomeReg, Registry<DimensionSettings> dimSettingsReg, long seed) {
        boolean classicBiomes = false;
        return new MiddleEarthChunkGenerator(new MiddleEarthBiomeProvider(seed, classicBiomes, biomeReg), seed, () -> (DimensionSettings)dimSettingsReg.func_243576_d(MIDDLE_EARTH_DIMSETTINGS_KEY), Optional.empty());
    }

    private static DimensionSettings createMiddleEarthDimensionSettings() {
        DimensionStructuresSettings dimStrSettings = new DimensionStructuresSettings(false);
        boolean isAmplified = false;
        double d0 = 0.9999999814507745;
        return new DimensionSettings(dimStrSettings, new NoiseSettings(256, new ScalingSettings(d0, d0, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, isAmplified), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), -10, 0, 63, false);
    }

    public static void registerAssociated() {
        LOTRDimensions.replaceDimensionCodecToForceStability();
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("lotr", "middle_earth"), MiddleEarthChunkGenerator.CODEC);
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("lotr", "middle_earth"), MiddleEarthBiomeProvider.CODEC);
        WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243658_j, (ResourceLocation)MIDDLE_EARTH_DIMSETTINGS_KEY.func_240901_a_(), (Object)MIDDLE_EARTH_DIMSETTINGS);
    }

    public static boolean isDimension(World world, RegistryKey<World> dimension) {
        return world.func_234923_W_().equals(dimension);
    }

    public static boolean isDimension(Faction fac, RegistryKey<World> dimension) {
        return fac.getDimension().equals(dimension);
    }

    public static boolean isModDimension(World world) {
        return world.func_230315_m_() instanceof LOTRDimensionType;
    }

    public static RegistryKey<World> getCurrentLOTRDimensionOrFallback(World world) {
        DimensionType dimension = world.func_230315_m_();
        if (dimension instanceof LOTRDimensionType) {
            return world.func_234923_W_();
        }
        return MIDDLE_EARTH_WORLD_KEY;
    }

    public static ITextComponent getDisplayName(RegistryKey<World> dimensionWorldKey) {
        ResourceLocation dimensionName = dimensionWorldKey.func_240901_a_();
        String key = String.format("dimension.%s.%s", dimensionName.func_110624_b(), dimensionName.func_110623_a());
        return new TranslationTextComponent(key);
    }

    public static BlockPos getDimensionSpawnPoint(ServerWorld world) {
        DimensionType dimension = world.func_230315_m_();
        if (dimension instanceof MiddleEarthDimensionType) {
            return ((MiddleEarthDimensionType)dimension).getSpawnCoordinate((World)world);
        }
        return world.func_241135_u_();
    }

    public static void replaceDimensionCodecToForceStability() {
        try {
            final Codec codec = DimensionGeneratorSettings.field_236201_a_;
            Codec<DimensionGeneratorSettings> stableCodec = new Codec<DimensionGeneratorSettings>(){

                public <T> DataResult<T> encode(DimensionGeneratorSettings input, DynamicOps<T> ops, T prefix) {
                    return codec.encode((Object)input, ops, prefix);
                }

                public <T> DataResult<Pair<DimensionGeneratorSettings, T>> decode(DynamicOps<T> ops, T input) {
                    DataResult result = codec.decode(ops, input);
                    return DataResult.success(result.result().orElseThrow(() -> new IllegalStateException("Failed to change lifecycle to stable")), (Lifecycle)Lifecycle.stable());
                }
            };
            Field f_codec = Stream.of(DimensionGeneratorSettings.class.getDeclaredFields()).filter(field -> (field.getModifiers() & 8) != 0).filter(field -> field.getType() == Codec.class).findFirst().orElseThrow(() -> new IllegalStateException("Failed to find codec field in DimensionGeneratorSettings"));
            LOTRUtil.unlockFinalField(f_codec);
            f_codec.set(null, stableCodec);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOTRLog.error("Failed to set dimension generator settings codec to stable");
        }
    }

    static {
        MIDDLE_EARTH_DIMSETTINGS_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)new ResourceLocation("lotr", "middle_earth"));
        MIDDLE_EARTH_DIMSETTINGS = LOTRDimensions.createMiddleEarthDimensionSettings();
    }
}

