/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import java.util.Optional;
import lotr.common.config.ClientsideCurrentServerConfigSettings;
import lotr.common.init.LOTRDimensions;
import lotr.common.world.gen.MiddleEarthChunkGenerator;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRWorldTypes {
    public static final DeferredRegister<ForgeWorldType> WORLD_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_TYPES, (String)"lotr");
    public static final RegistryObject<ForgeWorldType> MIDDLE_EARTH = WORLD_TYPES.register("me", () -> new ForgeWorldType(LOTRWorldTypes.createMiddleEarthWorldType(false)));
    public static final RegistryObject<ForgeWorldType> MIDDLE_EARTH_CLASSIC = WORLD_TYPES.register("me_classic", () -> new ForgeWorldType(LOTRWorldTypes.createMiddleEarthWorldType(true)));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        WORLD_TYPES.register(bus);
    }

    private static ForgeWorldType.IChunkGeneratorFactory createMiddleEarthWorldType(final boolean classicBiomes) {
        return new ForgeWorldType.IChunkGeneratorFactory(){

            public ChunkGenerator createChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimensionSettingsRegistry, long seed, String generatorSettings) {
                return LOTRWorldTypes.createDefaultOverworldChunkGenerator((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimensionSettingsRegistry, seed);
            }

            public DimensionGeneratorSettings createSettings(DynamicRegistries dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest, String generatorSettings) {
                ForgeWorldType.IChunkGeneratorFactory defaultMethodProxy = this::createChunkGenerator;
                DimensionGeneratorSettings settings = defaultMethodProxy.createSettings(dynamicRegistries, seed, generateStructures, bonusChest, generatorSettings);
                MiddleEarthChunkGenerator meChunkgen = (MiddleEarthChunkGenerator)((Object)LOTRWorldTypes.findMiddleEarthChunkGeneratorFromSettings(settings).orElseThrow(() -> new IllegalStateException("Expected to find a MiddleEarthChunkGenerator in new Middle-earth worldgen settings - this is a development error.")));
                meChunkgen.hackySetWorldTypeInstantMiddleEarth(true);
                meChunkgen.hackySetWorldTypeClassicBiomes(classicBiomes);
                return settings;
            }
        };
    }

    private static ChunkGenerator createDefaultOverworldChunkGenerator(Registry<Biome> biomeReg, Registry<DimensionSettings> dimSettingsReg, long seed) {
        return DimensionGeneratorSettings.func_242750_a(biomeReg, dimSettingsReg, (long)seed);
    }

    public static boolean hasMapFeatures(ServerWorld world) {
        DimensionGeneratorSettings dimGenSettings = world.func_73046_m().func_240793_aU_().func_230418_z_();
        Optional<MiddleEarthChunkGenerator> meChunkgen = LOTRWorldTypes.findMiddleEarthChunkGeneratorFromSettings(dimGenSettings);
        return meChunkgen.map(cg -> !cg.isClassicBiomes()).orElse(true);
    }

    public static boolean hasMapFeaturesClientside() {
        return ClientsideCurrentServerConfigSettings.INSTANCE.hasMapFeatures;
    }

    public static boolean isInstantME(ServerWorld world) {
        DimensionGeneratorSettings dimGenSettings = world.func_73046_m().func_240793_aU_().func_230418_z_();
        Optional<MiddleEarthChunkGenerator> meChunkgen = LOTRWorldTypes.findMiddleEarthChunkGeneratorFromSettings(dimGenSettings);
        return meChunkgen.map(MiddleEarthChunkGenerator::isInstantMiddleEarth).orElse(false);
    }

    private static Optional<MiddleEarthChunkGenerator> findMiddleEarthChunkGeneratorFromSettings(DimensionGeneratorSettings dimGenSettings) {
        ChunkGenerator chunkGen;
        SimpleRegistry dimRegistry = dimGenSettings.func_236224_e_();
        Dimension middleEarth = (Dimension)dimRegistry.func_230516_a_(LOTRDimensions.MIDDLE_EARTH_DIM_KEY);
        if (middleEarth != null && (chunkGen = middleEarth.func_236064_c_()) instanceof MiddleEarthChunkGenerator) {
            return Optional.of((MiddleEarthChunkGenerator)chunkGen);
        }
        return Optional.empty();
    }
}

