/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;

public class ItemOwnership {
    private static final int PREVIOUS_OWNERS_RECORDED = 3;

    public static void setCurrentOwner(ItemStack itemstack, ITextComponent name) {
        ITextComponent previousCurrentOwner = ItemOwnership.getCurrentOwner(itemstack);
        if (previousCurrentOwner != null) {
            ItemOwnership.addPreviousOwner(itemstack, previousCurrentOwner);
        }
        itemstack.func_190925_c("LOTROwnership").func_74778_a("CurrentOwner", ITextComponent.Serializer.func_150696_a((ITextComponent)name));
    }

    public static ITextComponent getCurrentOwner(ItemStack itemstack) {
        CompoundNBT nbt = itemstack.func_179543_a("LOTROwnership");
        if (nbt != null && nbt.func_150297_b("CurrentOwner", 8)) {
            String ownerJson = nbt.func_74779_i("CurrentOwner");
            return ITextComponent.Serializer.func_240644_b_((String)ownerJson);
        }
        return null;
    }

    public static void addPreviousOwner(ItemStack itemstack, ITextComponent name) {
        List<ITextComponent> previousOwners;
        List<ITextComponent> lastPreviousOwners = previousOwners = ItemOwnership.getPreviousOwners(itemstack);
        previousOwners = new ArrayList<ITextComponent>();
        previousOwners.add(name);
        previousOwners.addAll(lastPreviousOwners);
        while (previousOwners.size() > 3) {
            previousOwners.remove(previousOwners.size() - 1);
        }
        ListNBT tagList = new ListNBT();
        tagList.addAll((Collection)previousOwners.stream().map(ITextComponent.Serializer::func_150696_a).map(StringNBT::func_229705_a_).collect(Collectors.toList()));
        CompoundNBT nbt = itemstack.func_190925_c("LOTROwnership");
        nbt.func_218657_a("PreviousOwners", (INBT)tagList);
    }

    public static List<ITextComponent> getPreviousOwners(ItemStack itemstack) {
        ArrayList<ITextComponent> owners = new ArrayList<ITextComponent>();
        CompoundNBT nbt = itemstack.func_179543_a("LOTROwnership");
        if (nbt != null && nbt.func_150297_b("PreviousOwners", 9)) {
            ListNBT tagList = nbt.func_150295_c("PreviousOwners", 8);
            for (int i = 0; i < tagList.size(); ++i) {
                String ownerJson = tagList.func_150307_f(i);
                owners.add((ITextComponent)ITextComponent.Serializer.func_240644_b_((String)ownerJson));
            }
        }
        return owners;
    }
}

