/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import java.util.function.Predicate;
import lotr.common.dispenser.DispenseLOTRBoat;
import lotr.common.entity.item.LOTRBoatEntity;
import lotr.common.init.LOTRItemGroups;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class LOTRBoatItem
extends Item {
    private static final Predicate<Entity> entitySelector = EntityPredicates.field_180132_d.and(Entity::func_70067_L);
    private final LOTRBoatEntity.ModBoatType boatType;

    public LOTRBoatItem(LOTRBoatEntity.ModBoatType type) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(LOTRItemGroups.MISC));
        this.boatType = type;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenseLOTRBoat(this.boatType));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        BlockRayTraceResult target = LOTRBoatItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (target.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        Vector3d look = player.func_70676_i(1.0f);
        double reach = 5.0;
        List collidedEntities = world.func_175674_a((Entity)player, player.func_174813_aQ().func_216361_a(look.func_186678_a(reach)).func_186662_g(1.0), entitySelector);
        if (!collidedEntities.isEmpty()) {
            Vector3d eyePos = player.func_174824_e(1.0f);
            for (Entity entity : collidedEntities) {
                AxisAlignedBB bb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!bb.func_72318_a(eyePos)) continue;
                return ActionResult.func_226250_c_((Object)heldItem);
            }
        }
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            LOTRBoatEntity boat = new LOTRBoatEntity(world, target.func_216347_e().field_72450_a, target.func_216347_e().field_72448_b, target.func_216347_e().field_72449_c);
            boat.setModBoatType(this.boatType);
            boat.field_70177_z = player.field_70177_z;
            if (!world.func_226665_a__((Entity)boat, boat.func_174813_aQ().func_186662_g(-0.1))) {
                return ActionResult.func_226251_d_((Object)heldItem);
            }
            if (!world.field_72995_K) {
                world.func_217376_c((Entity)boat);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }
}

