/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import lotr.common.init.LOTRItemGroups;
import lotr.common.init.LOTRMaterial;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraftforge.common.ForgeMod;

public class LOTRSwordItem
extends SwordItem {
    private Multimap<Attribute, AttributeModifier> extendedAttributeModifiers;
    protected static final UUID ATTACK_REACH_MODIFIER = UUID.fromString("8e3d7974-9a16-47d5-a6b1-02f248a5aa32");

    public LOTRSwordItem(IItemTier tier) {
        this(tier, 3, -2.4f);
    }

    public LOTRSwordItem(IItemTier tier, int atk, float speed) {
        super(tier, atk, speed, new Item.Properties().func_200916_a(LOTRItemGroups.COMBAT));
    }

    public LOTRSwordItem(LOTRMaterial material) {
        this(material.asTool());
    }

    public LOTRSwordItem(LOTRMaterial material, int extraAtk) {
        this(material.asTool(), 3 + extraAtk, -2.4f);
    }

    protected void setupExtendedMeleeAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        this.addReachModifier(builder, 0.0);
    }

    protected final void addReachModifier(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, double reach) {
        builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", reach, AttributeModifier.Operation.ADDITION));
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        if (this.extendedAttributeModifiers == null) {
            this.extendedAttributeModifiers = this.buildExtendedAttributeModifiers();
        }
        return slot == EquipmentSlotType.MAINHAND ? this.extendedAttributeModifiers : super.func_111205_h(slot);
    }

    private Multimap<Attribute, AttributeModifier> buildExtendedAttributeModifiers() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        Multimap baseSwordModifiers = super.func_111205_h(EquipmentSlotType.MAINHAND);
        builder.putAll(baseSwordModifiers);
        this.setupExtendedMeleeAttributes((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder);
        return builder.build();
    }
}

