/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import lotr.common.entity.projectile.SmokeRingEntity;
import lotr.common.init.LOTRItemGroups;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.util.LOTRUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SmokingPipeItem
extends Item {
    private final int smokeFood = 2;
    private final float smokeSaturation = 0.3f;

    public SmokingPipeItem(Item.Properties properties) {
        super(properties);
    }

    public SmokingPipeItem() {
        this(new Item.Properties().func_200918_c(300).func_200916_a(LOTRItemGroups.MISC));
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.canSmoke((LivingEntity)player)) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)heldItem);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }

    private boolean canSmoke(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
            ItemStack smokedItem = LOTRUtil.findHeldOrInventoryItem(player, this::isSmokable);
            return !smokedItem.func_190926_b();
        }
        return true;
    }

    private boolean isSmokable(ItemStack stack) {
        return stack.func_77973_b() == LOTRItems.PIPEWEED.get();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (this.canSmoke(entity)) {
            stack.func_222118_a(1, entity, e -> e.func_213334_d(e.func_184600_cs()));
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                ItemStack smokedItem = LOTRUtil.findHeldOrInventoryItem(player, this::isSmokable);
                if (!smokedItem.func_190926_b()) {
                    LOTRUtil.consumeOneInventoryItem(player, smokedItem);
                }
                if (player.func_71043_e(false)) {
                    player.func_71024_bL().func_75122_a(2, 0.3f);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            } else {
                entity.func_70691_i(2.0f);
            }
            if (!world.field_72995_K) {
                SmokeRingEntity smoke = new SmokeRingEntity(world, entity);
                DyeColor color = SmokingPipeItem.getSmokeColor(stack);
                boolean magic = SmokingPipeItem.isMagicSmoke(stack);
                smoke.setSmokeColor(color);
                smoke.setMagicSmoke(magic);
                float speed = 0.1f;
                smoke.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 0.0f);
                world.func_217376_c((Entity)smoke);
            }
            entity.func_184185_a(LOTRSoundEvents.SMOKE_PUFF, 1.0f, (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.2f + 1.0f);
        }
        return stack;
    }

    public static void setSmokeColor(ItemStack stack, DyeColor color) {
        stack.func_190925_c("pipe").func_74778_a("color", color.func_176610_l());
    }

    public static void clearSmokeColor(ItemStack stack) {
        SmokingPipeItem.setSmokeColor(stack, DyeColor.WHITE);
    }

    public static DyeColor getSmokeColor(ItemStack stack) {
        DyeColor color = SmokingPipeItem.getSavedSmokeColor(stack);
        return color != null ? color : DyeColor.WHITE;
    }

    private static DyeColor getSavedSmokeColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("pipe");
        if (nbt != null && nbt.func_150297_b("color", 8)) {
            return DyeColor.func_204271_a((String)nbt.func_74779_i("color"), (DyeColor)DyeColor.WHITE);
        }
        return null;
    }

    public static boolean isSmokeDyed(ItemStack stack) {
        DyeColor color = SmokingPipeItem.getSavedSmokeColor(stack);
        return color != null && color != DyeColor.WHITE;
    }

    public static void setMagicSmoke(ItemStack stack, boolean flag) {
        stack.func_190925_c("pipe").func_74757_a("magic", flag);
    }

    public static boolean isMagicSmoke(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("pipe");
        if (nbt != null) {
            return nbt.func_74767_n("magic");
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        DyeColor color = SmokingPipeItem.getSmokeColor(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("%s.%s", this.func_195935_o(), color.func_176762_d())).func_240699_a_(TextFormatting.GRAY));
        if (SmokingPipeItem.isMagicSmoke(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("%s.%s", this.func_195935_o(), "magic")).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack pipe;
            for (DyeColor color : DyeColor.values()) {
                pipe = new ItemStack((IItemProvider)this);
                SmokingPipeItem.setSmokeColor(pipe, color);
                items.add((Object)pipe);
            }
            for (DyeColor color : DyeColor.values()) {
                pipe = new ItemStack((IItemProvider)this);
                SmokingPipeItem.setSmokeColor(pipe, color);
                SmokingPipeItem.setMagicSmoke(pipe, true);
                items.add((Object)pipe);
            }
        }
    }
}

