/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import lotr.common.item.LOTRBlockItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class WaterPlantBlockItem
extends LOTRBlockItem {
    public WaterPlantBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.canAttemptPlaceNormally(context)) {
            return super.func_195939_a(context);
        }
        return ActionResultType.PASS;
    }

    protected boolean canAttemptPlaceNormally(ItemUseContext context) {
        return false;
    }

    protected boolean canPlaceOnIce() {
        return false;
    }

    protected void playPlaceSound(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.playNormalPlaceSound(world, pos, state, player);
    }

    protected final void playNormalPlaceSound(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        SoundType sound = state.getSoundType((IWorldReader)world, pos, (Entity)player);
        world.func_184133_a(player, pos, this.getPlaceSound(state, world, pos, player), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockRayTraceResult blockTarget = WaterPlantBlockItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        BlockRayTraceResult blockTargetAbove = blockTarget.func_237485_a_(blockTarget.func_216350_a().func_177984_a());
        ActionResultType result = super.func_195939_a(new ItemUseContext(player, hand, blockTargetAbove));
        return new ActionResult(result, (Object)player.func_184586_b(hand));
    }
}

