/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import lotr.common.fac.EntityFactionHelper;
import lotr.common.fac.Faction;
import lotr.common.item.PouchItem;
import lotr.common.loot.functions.LOTRLootFunctions;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;

public class SetPouchColorFromEntityFaction
extends LootFunction {
    private final float chance;

    private SetPouchColorFromEntityFaction(ILootCondition[] conditions, float chance) {
        super(conditions);
        this.chance = chance;
    }

    public LootFunctionType func_230425_b_() {
        return LOTRLootFunctions.SET_POUCH_COLOR_FROM_ENTITY_FACTION;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Faction faction;
        Entity entity;
        if (context.func_216032_b().nextFloat() < this.chance && stack.func_77973_b() instanceof PouchItem && (entity = (Entity)context.func_216031_c(LootParameters.field_216281_a)) != null && (faction = EntityFactionHelper.getFaction(entity)).isPlayableAlignmentFaction()) {
            PouchItem.setPouchDyedByFaction(stack, faction);
        }
        return stack;
    }

    public static LootFunction.Builder<?> setPouchColorFromEntityFactionBuilder(float chance) {
        return SetPouchColorFromEntityFaction.func_215860_a(conditions -> new SetPouchColorFromEntityFaction((ILootCondition[])conditions, chance));
    }

    public static class Serializer
    extends LootFunction.Serializer<SetPouchColorFromEntityFaction> {
        public void serialize(JsonObject object, SetPouchColorFromEntityFaction function, JsonSerializationContext context) {
            super.func_230424_a_(object, (LootFunction)function, context);
            object.addProperty("chance", (Number)Float.valueOf(function.chance));
        }

        public SetPouchColorFromEntityFaction deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] conditions) {
            float chance = JSONUtils.func_151221_a((JsonObject)object, (String)"chance", (float)1.0f);
            return new SetPouchColorFromEntityFaction(conditions, chance);
        }
    }
}

