/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.loot.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootGenerator;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.apache.commons.lang3.mutable.MutableInt;

public class PolarBearBlubberModifier
extends LootModifier {
    private final LootEntry extraEntry;

    public PolarBearBlubberModifier(ILootCondition[] conds, LootEntry extraEntry) {
        super(conds);
        this.extraEntry = extraEntry;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity instanceof PolarBearEntity) {
            Consumer stacksOut = stack -> generatedLoot.add((ItemStack)stack);
            stacksOut = LootTable.func_216124_a(stacksOut);
            Consumer consumer = ILootFunction.func_215858_a((BiFunction)LootFunctionManager.field_216242_a, (Consumer)stacksOut, (LootContext)context);
            this.generateExtraLootEntry(consumer, context);
        }
        return generatedLoot;
    }

    private void generateExtraLootEntry(Consumer<ItemStack> consumer, LootContext context) {
        Random random = context.func_216032_b();
        ArrayList lootGens = Lists.newArrayList();
        MutableInt totalWeight = new MutableInt();
        for (LootEntry lootentry : ImmutableList.of((Object)this.extraEntry)) {
            lootentry.expand(context, gen -> {
                int weight = gen.func_186361_a(context.func_186491_f());
                if (weight > 0) {
                    lootGens.add(gen);
                    totalWeight.add(weight);
                }
            });
        }
        int numLootGens = lootGens.size();
        if (totalWeight.intValue() != 0 && numLootGens != 0) {
            if (numLootGens == 1) {
                ((ILootGenerator)lootGens.get(0)).func_216188_a(consumer, context);
            } else {
                int weight = random.nextInt(totalWeight.intValue());
                for (ILootGenerator ilootgenerator : lootGens) {
                    if ((weight -= ilootgenerator.func_186361_a(context.func_186491_f())) >= 0) continue;
                    ilootgenerator.func_216188_a(consumer, context);
                    return;
                }
            }
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<PolarBearBlubberModifier> {
        private static final Gson GSON_WITH_LOOT_ENTRY_ADAPTER = LootSerializers.func_237387_b_().create();

        public PolarBearBlubberModifier read(ResourceLocation name, JsonObject obj, ILootCondition[] conditions) {
            LootEntry extraEntry = (LootEntry)GSON_WITH_LOOT_ENTRY_ADAPTER.fromJson(obj.get("extra_entry"), LootEntry.class);
            return new PolarBearBlubberModifier(conditions, extraEntry);
        }

        public JsonObject write(PolarBearBlubberModifier instance) {
            JsonObject obj = this.makeConditions(instance.conditions);
            obj.add("extra_entry", GSON_WITH_LOOT_ENTRY_ADAPTER.toJsonTree((Object)instance.extraEntry));
            return obj;
        }
    }
}

