/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.world.map.CustomWaypoint;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketCustomWaypointAdoptedCount {
    private final int waypointId;
    private final int adoptedCount;

    public SPacketCustomWaypointAdoptedCount(CustomWaypoint waypoint, int adoptedCount) {
        this(waypoint.getCustomId(), adoptedCount);
    }

    private SPacketCustomWaypointAdoptedCount(int waypointId, int adoptedCount) {
        this.waypointId = waypointId;
        this.adoptedCount = adoptedCount;
    }

    public static void encode(SPacketCustomWaypointAdoptedCount packet, PacketBuffer buf) {
        buf.func_150787_b(packet.waypointId);
        buf.func_150787_b(packet.adoptedCount);
    }

    public static SPacketCustomWaypointAdoptedCount decode(PacketBuffer buf) {
        int waypointId = buf.func_150792_a();
        int adoptedCount = buf.func_150792_a();
        return new SPacketCustomWaypointAdoptedCount(waypointId, adoptedCount);
    }

    public static void handle(SPacketCustomWaypointAdoptedCount packet, Supplier<NetworkEvent.Context> context) {
        int waypointId;
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        FastTravelDataModule ftData = LOTRLevelData.clientInstance().getData(player).getFastTravelData();
        CustomWaypoint waypoint = ftData.getCustomWaypointById(waypointId = packet.waypointId);
        if (waypoint != null) {
            waypoint.receiveAdoptedCountFromServer(packet.adoptedCount);
        } else {
            LOTRLog.warn("Received custom waypoint adopted count from server, but no custom waypoint for ID %d exists", waypointId);
        }
        context.get().setPacketHandled(true);
    }
}

