/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import lotr.common.LOTRMod;
import lotr.common.world.map.MapPlayerLocation;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketMapPlayerLocations {
    private final List<MapPlayerLocation> playerLocations;

    public SPacketMapPlayerLocations(List<MapPlayerLocation> players) {
        this.playerLocations = players;
    }

    public static void encode(SPacketMapPlayerLocations packet, PacketBuffer buf) {
        List<MapPlayerLocation> playerLocations = packet.playerLocations;
        int players = playerLocations.size();
        buf.writeInt(players);
        for (MapPlayerLocation loc : playerLocations) {
            buf.func_179252_a(loc.profile.getId());
            buf.writeDouble(loc.posX);
            buf.writeDouble(loc.posZ);
        }
    }

    public static SPacketMapPlayerLocations decode(PacketBuffer buf) {
        ArrayList<MapPlayerLocation> playerLocations = new ArrayList<MapPlayerLocation>();
        int players = buf.readInt();
        for (int i = 0; i < players; ++i) {
            UUID playerID = buf.func_179253_g();
            double posX = buf.readDouble();
            double posZ = buf.readDouble();
            playerLocations.add(new MapPlayerLocation(new GameProfile(playerID, null), posX, posZ));
        }
        return new SPacketMapPlayerLocations(playerLocations);
    }

    public static void handle(SPacketMapPlayerLocations packet, Supplier<NetworkEvent.Context> context) {
        LOTRMod.PROXY.mapHandlePlayerLocations(packet.playerLocations);
        context.get().setPacketHandled(true);
    }
}

