/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketNPCState {
    private final int entityId;
    private final Type type;
    private final boolean state;

    private SPacketNPCState(int entityId, Type type, boolean state) {
        this.entityId = entityId;
        this.type = type;
        this.state = state;
    }

    public SPacketNPCState(NPCEntity entity, Type type, boolean state) {
        this(entity.func_145782_y(), type, state);
    }

    public static void encode(SPacketNPCState packet, PacketBuffer buf) {
        buf.writeInt(packet.entityId);
        buf.writeByte(packet.type.ordinal());
        buf.writeBoolean(packet.state);
    }

    public static SPacketNPCState decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        Type type = Type.forId(buf.readByte());
        boolean state = buf.readBoolean();
        return new SPacketNPCState(entityId, type, state);
    }

    public static void handle(SPacketNPCState packet, Supplier<NetworkEvent.Context> context) {
        World world = LOTRMod.PROXY.getClientWorld();
        Type type = packet.type;
        int entityId = packet.entityId;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            boolean state = packet.state;
            if (type == Type.IS_EATING) {
                npc.getNPCItemsInv().receiveClientIsEating(state);
            } else if (type == Type.COMBAT_STANCE) {
                npc.getNPCCombatUpdater().receiveClientCombatStance(state);
            } else {
                LOTRLog.error("Received SPacketNPCState with unsupported type %s!", type.name());
            }
        } else {
            LOTRLog.warn("Received SPacketNPCState (type %s) for client-side entity ID %d, but entity was %s (not an NPC)", type.name(), entityId, entity);
        }
        context.get().setPacketHandled(true);
    }

    public static enum Type {
        IS_EATING,
        COMBAT_STANCE;


        public static Type forId(int id) {
            return Type.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(Type.values().length - 1))];
        }
    }
}

