/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRMod;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.world.map.Waypoint;
import lotr.common.world.map.WaypointNetworkType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketWaypointUseCount {
    private final Waypoint waypoint;
    private final int useCount;

    public SPacketWaypointUseCount(Waypoint wp, int count) {
        this.waypoint = wp;
        this.useCount = count;
    }

    public static void encode(SPacketWaypointUseCount packet, PacketBuffer buf) {
        WaypointNetworkType.writeIdentification(buf, packet.waypoint);
        buf.func_150787_b(packet.useCount);
    }

    public static SPacketWaypointUseCount decode(PacketBuffer buf) {
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        Waypoint waypoint = WaypointNetworkType.readFromIdentification(buf, pd);
        int useCount = buf.func_150792_a();
        return new SPacketWaypointUseCount(waypoint, useCount);
    }

    public static void handle(SPacketWaypointUseCount packet, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = LOTRMod.PROXY.getClientPlayer();
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        FastTravelDataModule ftData = pd.getFastTravelData();
        ftData.setWPUseCount(packet.waypoint, packet.useCount);
        context.get().setPacketHandled(true);
    }
}

