/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.data.LOTRPlayerData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class SidedTogglePacket {
    private final ToggleType type;
    private final boolean fieldValue;

    public SidedTogglePacket(ToggleType type, boolean fieldValue) {
        this.type = type;
        this.fieldValue = fieldValue;
    }

    protected static void encode(SidedTogglePacket packet, PacketBuffer buf) {
        buf.writeByte(packet.type.ordinal());
        buf.writeBoolean(packet.fieldValue);
    }

    public static <P extends SidedTogglePacket> P decode(PacketBuffer buf, BiFunction<ToggleType, Boolean, P> packetConstructor) {
        ToggleType type = ToggleType.forId(buf.readByte());
        boolean fieldValue = buf.readBoolean();
        return (P)((SidedTogglePacket)packetConstructor.apply(type, fieldValue));
    }

    protected abstract LOTRPlayerData getSidedPlayerData(Supplier<NetworkEvent.Context> var1);

    public static void handle(SidedTogglePacket packet, Supplier<NetworkEvent.Context> context) {
        LOTRPlayerData pd = packet.getSidedPlayerData(context);
        ToggleType type = packet.type;
        boolean fieldValue = packet.fieldValue;
        if (type == ToggleType.SHOW_MAP_LOCATION) {
            pd.getMiscData().setShowMapLocation(fieldValue);
        } else if (type == ToggleType.SHOW_MAP_MARKERS) {
            pd.getMapMarkerData().setShowMarkers(fieldValue);
        } else if (type == ToggleType.FRIENDLY_FIRE) {
            pd.getAlignmentData().setFriendlyFireEnabled(fieldValue);
        } else {
            LOTRLog.error("Received %s with unsupported type %s!", packet.getClass().getSimpleName(), type.name());
        }
        context.get().setPacketHandled(true);
    }

    public static enum ToggleType {
        SHOW_MAP_LOCATION,
        SHOW_MAP_MARKERS,
        FRIENDLY_FIRE;


        public static ToggleType forId(int id) {
            return ToggleType.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(ToggleType.values().length - 1))];
        }
    }
}

